/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.portal;

import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.gadgets.dashboard.Layout;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.util.dbc.Assertions;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@PublicApi
public final class PortalPage
implements SharedEntity {
    public static final SharedEntity.TypeDescriptor<PortalPage> ENTITY_TYPE = SharedEntity.TypeDescriptor.Factory.get().create("PortalPage");
    private final Long id;
    private final String name;
    private final String ownerUserName;
    private final String description;
    private final Long favouriteCount;
    private final Layout layout;
    private final Long version;
    private final boolean systemDashboard;
    private final SharedEntity.SharePermissions sharePermissions;

    private PortalPage(Long id, String name, String description, String ownerUserName, Long favouriteCount, Layout layout, Long version, SharedEntity.SharePermissions sharePermissions, boolean isSystemDashboard) {
        this.id = id;
        this.name = name;
        this.ownerUserName = ownerUserName;
        this.description = description;
        this.favouriteCount = favouriteCount;
        this.version = version;
        this.systemDashboard = isSystemDashboard;
        this.layout = layout;
        this.sharePermissions = sharePermissions;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public Long getVersion() {
        return this.version;
    }

    public boolean isSystemDefaultPortalPage() {
        return this.systemDashboard;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Layout getLayout() {
        return this.layout;
    }

    @Override
    public Long getFavouriteCount() {
        return this.favouriteCount;
    }

    public final SharedEntity.TypeDescriptor<PortalPage> getEntityType() {
        return ENTITY_TYPE;
    }

    @Override
    public String getOwnerUserName() {
        return this.ownerUserName;
    }

    @Override
    public SharedEntity.SharePermissions getPermissions() {
        return this.sharePermissions;
    }

    public static Builder portalPage(PortalPage page) {
        return new Builder().portalPage(page);
    }

    public static Builder id(Long id) {
        return new Builder().id(id);
    }

    public static Builder name(String name) {
        return new Builder().name(name);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PortalPage rhs = (PortalPage)obj;
        return new EqualsBuilder().append((Object)this.id, (Object)rhs.id).append((Object)this.name, (Object)rhs.name).append((Object)this.description, (Object)rhs.description).append((Object)this.favouriteCount, (Object)rhs.favouriteCount).append((Object)this.sharePermissions, (Object)rhs.sharePermissions).append((Object)this.layout, (Object)rhs.layout).append((Object)this.ownerUserName, (Object)rhs.ownerUserName).append((Object)this.version, (Object)rhs.version).append(this.systemDashboard, rhs.systemDashboard).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 33).append((Object)this.id).append((Object)this.name).append((Object)this.description).append((Object)this.favouriteCount).append((Object)this.sharePermissions).append((Object)this.layout).append((Object)this.ownerUserName).append((Object)this.version).append(this.systemDashboard).hashCode();
    }

    public static class Builder {
        private boolean isSystemDashboard = false;
        private Long id;
        private String description;
        private String name;
        private Long favouriteCount = 0L;
        private SharedEntity.SharePermissions permissions = SharedEntity.SharePermissions.PRIVATE;
        private Layout layout = Layout.AA;
        private String ownerUserName;
        private Long version = 0L;

        public Builder portalPage(PortalPage page) {
            this.id = page.getId();
            this.name = page.getName();
            this.description = page.getDescription();
            this.isSystemDashboard = page.isSystemDefaultPortalPage();
            this.favouriteCount = page.getFavouriteCount();
            this.permissions = page.getPermissions();
            this.layout = page.getLayout();
            this.ownerUserName = page.getOwnerUserName();
            this.version = page.getVersion();
            return this;
        }

        public Builder id(Long id) {
            Assertions.notNull("id", id);
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder owner(String username) {
            if (this.isSystemDashboard) {
                throw new IllegalStateException("System Dashboard cannot have an owner!");
            }
            this.ownerUserName = username == null ? username : IdentifierUtils.toLowerCase((String)username);
            return this;
        }

        public Builder permissions(SharedEntity.SharePermissions permissions) {
            this.permissions = permissions;
            return this;
        }

        public Builder systemDashboard() {
            if (this.ownerUserName != null) {
                throw new IllegalStateException("System Dashboard cannot have an owner!");
            }
            this.isSystemDashboard = true;
            return this;
        }

        public Builder favouriteCount(Long favouriteCount) {
            this.favouriteCount = favouriteCount == null ? 0L : favouriteCount;
            return this;
        }

        public Builder layout(Layout layout) {
            this.layout = layout;
            return this;
        }

        public Builder version(Long version) {
            this.version = version;
            return this;
        }

        public PortalPage build() {
            if (this.isSystemDashboard && this.ownerUserName != null) {
                throw new IllegalStateException("System Dashboard cannot have an owner!");
            }
            return new PortalPage(this.id, this.name, this.description, this.ownerUserName, this.favouriteCount, this.layout, this.version, this.permissions, this.isSystemDashboard);
        }
    }
}

