/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.core.util.ClassLoaderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class HelpUtil {
    private final Logger log = Logger.getLogger(HelpUtil.class);
    static final String HELP_PATH_CONFIG_LOCATION = "help-paths.properties";
    static final String INTERNAL_HELP_PATH_CONFIG_LOCATION = "internal-help-paths.properties";
    private static HelpPath defaultHelpPath;
    private static volatile Map<String, HelpPath> helpPaths;
    private static volatile HelpUtil instance;

    public HelpUtil() {
        this(HELP_PATH_CONFIG_LOCATION, INTERNAL_HELP_PATH_CONFIG_LOCATION);
    }

    public HelpUtil(String externalPropertiesFileLocation, String internalPropertiesFileLocation) {
        this.init(externalPropertiesFileLocation, internalPropertiesFileLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String externalPropertiesFileLocation, String internalPropertiesFileLocation) {
        Class<HelpUtil> clazz = HelpUtil.class;
        synchronized (HelpUtil.class) {
            if (helpPaths == null) {
                Properties properties = this.loadProperties(externalPropertiesFileLocation);
                this.loadExternalProperties(properties, true);
                properties = this.loadProperties(internalPropertiesFileLocation);
                this.loadInternalProperties(properties);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private Properties loadProperties(String propertiesFileLocation) {
        Properties properties = new Properties();
        try {
            InputStream is = ClassLoaderUtils.getResourceAsStream((String)propertiesFileLocation, this.getClass());
            properties.load(is);
            is.close();
        }
        catch (IOException e) {
            this.log.error((Object)("Error loading helpfile " + propertiesFileLocation + ": " + e), (Throwable)e);
        }
        return properties;
    }

    public HelpUtil(Properties externalProperties) {
        this.loadExternalProperties(externalProperties, true);
    }

    public HelpPath getHelpPath(String helpPathKey) {
        HelpPath theHelpPath = helpPaths.get(helpPathKey);
        if (theHelpPath == null) {
            return defaultHelpPath;
        }
        return theHelpPath;
    }

    public Set<String> keySet() {
        return new HashSet<String>(helpPaths.keySet());
    }

    private void loadExternalProperties(Properties properties, boolean reload) {
        if (helpPaths == null || reload) {
            HashMap<String, HelpPath> newPaths = new HashMap<String, HelpPath>();
            String urlPrefix = properties.getProperty("url-prefix");
            String urlSuffix = properties.getProperty("url-suffix");
            defaultHelpPath = this.loadHelpPath("default", properties, urlPrefix, urlSuffix, null);
            Enumeration<?> propertyNames = properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String property = (String)propertyNames.nextElement();
                int urlIndex = property.indexOf(".url");
                if (urlIndex == -1) continue;
                String propertyName = property.substring(0, urlIndex);
                HelpPath helpPath = this.loadHelpPath(propertyName, properties, urlPrefix, urlSuffix, defaultHelpPath);
                newPaths.put(helpPath.getKey(), helpPath);
            }
            helpPaths = newPaths;
        }
    }

    private void loadInternalProperties(Properties properties) {
        for (String string : properties.keySet()) {
            if (!string.endsWith(".path")) continue;
            String key = string.substring(0, string.length() - 5);
            HelpPath helpPath = new HelpPath();
            helpPath.setKey(key);
            helpPath.setUrl((String)properties.get(string));
            helpPath.setTitle((String)properties.get(key + ".title"));
            helpPath.setLocal(Boolean.TRUE);
            helpPaths.put(key, helpPath);
        }
    }

    private HelpPath loadHelpPath(String name, Properties props, String prefix, String suffix, HelpPath defaultHelpPath) {
        String title;
        String alt;
        HelpPath helpPath = defaultHelpPath == null ? new HelpPath() : (HelpPath)defaultHelpPath.clone();
        helpPath.setKey(name);
        String url = props.getProperty(name + ".url");
        if (url != null) {
            String builtURL = this.buildValidUrl(prefix, url, suffix);
            if (this.isExternalLink(url)) {
                builtURL = this.buildValidUrl("", url, "");
            }
            helpPath.setUrl(builtURL);
        }
        if ((alt = props.getProperty(name + ".alt")) != null) {
            helpPath.setAlt(alt);
        }
        if ((title = props.getProperty(name + ".title")) != null) {
            helpPath.setTitle(title);
        }
        return helpPath;
    }

    private String buildValidUrl(String prefix, String url, String suffix) {
        String targetUrl = url;
        String targetSuffix = suffix;
        int hashIndex = url.indexOf("#");
        if (hashIndex != -1 && (suffix.contains("?") || suffix.contains("&"))) {
            targetUrl = url.substring(0, hashIndex);
            targetSuffix = suffix + url.substring(hashIndex);
        }
        return prefix + targetUrl + targetSuffix;
    }

    private boolean isExternalLink(String url) {
        String urlLowerCase = url.toLowerCase();
        return urlLowerCase.startsWith("http://") || urlLowerCase.startsWith("https://");
    }

    public static HelpUtil getInstance() {
        if (instance == null) {
            instance = new HelpUtil();
        }
        return instance;
    }

    public class HelpPath
    implements Cloneable {
        String url;
        String alt;
        String title;
        String key;
        Boolean local;

        public String getUrl() {
            return this.url;
        }

        public String getAlt() {
            return this.alt;
        }

        public String getTitle() {
            return this.title;
        }

        public String getKey() {
            return this.key;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setAlt(String alt) {
            this.alt = alt;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Boolean isLocal() {
            return this.local;
        }

        public Boolean getLocal() {
            return this.local;
        }

        public void setLocal(Boolean local) {
            this.local = local;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                HelpUtil.this.log.error((Object)e, (Throwable)e);
                return null;
            }
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("url", (Object)this.url).append("title", (Object)this.title).append("key", (Object)this.key).append("alt", (Object)this.alt).toString();
        }
    }
}

