/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public interface StatisticGatherer {
    public Number getValue(Number var1, int var2);

    public static class CountUniqueValue
    extends Number {
        private final Set values = new HashSet();

        public void addValue(int value) {
            this.values.add(new Integer(value));
        }

        @Override
        public int intValue() {
            return this.values.size();
        }

        @Override
        public long longValue() {
            return this.intValue();
        }

        @Override
        public float floatValue() {
            return this.intValue();
        }

        @Override
        public double doubleValue() {
            return this.intValue();
        }

        public String toString() {
            return String.valueOf(this.intValue());
        }
    }

    public static class MedianValue
    extends Number {
        private final List values = new ArrayList();

        public void addValue(int value) {
            this.values.add(new Integer(value));
        }

        @Override
        public int intValue() {
            Collections.sort(this.values, new Comparator(){

                public int compare(Object o, Object o1) {
                    if (o == null) {
                        return -1;
                    }
                    if (o1 == null) {
                        return 1;
                    }
                    return ((Integer)o).compareTo((Integer)o1);
                }
            });
            if (this.values.isEmpty()) {
                return 0;
            }
            if (this.values.size() % 2 == 0) {
                int i = (Integer)this.values.get(this.values.size() / 2);
                int j = (Integer)this.values.get(this.values.size() / 2 - 1);
                return (i + j) / 2;
            }
            return (Integer)this.values.get(this.values.size() / 2);
        }

        @Override
        public long longValue() {
            return this.intValue();
        }

        @Override
        public float floatValue() {
            return this.intValue();
        }

        @Override
        public double doubleValue() {
            return this.intValue();
        }

        public String toString() {
            return String.valueOf(this.intValue());
        }
    }

    public static class MeanValue
    extends Number {
        private int total;
        private int count;

        public void addValue(int value) {
            this.total += value;
            ++this.count;
        }

        @Override
        public int intValue() {
            return this.total / this.count;
        }

        @Override
        public long longValue() {
            return this.intValue();
        }

        @Override
        public float floatValue() {
            return this.intValue();
        }

        @Override
        public double doubleValue() {
            return this.intValue();
        }

        public String toString() {
            return String.valueOf(this.intValue());
        }
    }

    public static class CountUnique
    implements StatisticGatherer {
        @Override
        public Number getValue(Number current, int newValue) {
            CountUniqueValue countUniqueValue = (CountUniqueValue)current;
            if (countUniqueValue == null) {
                countUniqueValue = new CountUniqueValue();
            }
            countUniqueValue.addValue(newValue);
            return countUniqueValue;
        }
    }

    public static class Median
    implements StatisticGatherer {
        @Override
        public Number getValue(Number current, int newValue) {
            MedianValue medianValue = (MedianValue)current;
            if (medianValue == null) {
                medianValue = new MedianValue();
            }
            medianValue.addValue(newValue);
            return medianValue;
        }
    }

    public static class Mean
    implements StatisticGatherer {
        @Override
        public Number getValue(Number current, int newValue) {
            MeanValue meanValue = (MeanValue)current;
            if (meanValue == null) {
                meanValue = new MeanValue();
            }
            meanValue.addValue(newValue);
            return meanValue;
        }
    }

    public static class Sum
    implements StatisticGatherer {
        @Override
        public Number getValue(Number current, int newValue) {
            current = current == null ? new Integer(newValue) : new Integer(newValue + current.intValue());
            return current;
        }
    }
}

