/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.query.operator;

import com.atlassian.jira.util.Predicate;
import java.util.Comparator;
import javax.annotation.concurrent.Immutable;

@Immutable
public enum Operator {
    LIKE("~"){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            throw new IllegalStateException("You can not get a predicate for the '~' operator.");
        }
    }
    ,
    NOT_LIKE("!~"){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            throw new IllegalStateException("You can not get a predicate for the '!~' operator.");
        }
    }
    ,
    EQUALS("="){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            throw new IllegalStateException("You can not get a predicate for the '=' operator.");
        }
    }
    ,
    NOT_EQUALS("!="){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            throw new IllegalStateException("You can not get a predicate for the '!=' operator.");
        }
    }
    ,
    IN("in"){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            throw new IllegalStateException("You can not get a predicate for the 'in' operator.");
        }
    }
    ,
    NOT_IN("not in"){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            throw new IllegalStateException("You can not get a predicate for the 'not in' operator.");
        }
    }
    ,
    IS("is"){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            throw new IllegalStateException("You can not get a predicate for the 'is' operator.");
        }
    }
    ,
    IS_NOT("is not"){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            throw new IllegalStateException("You can not get a predicate for the 'is not' operator.");
        }
    }
    ,
    LESS_THAN("<"){

        @Override
        public <T> Predicate<T> getPredicateForValue(final Comparator<? super T> comparator, final T operand) {
            return new Predicate<T>(){

                @Override
                public boolean evaluate(T input) {
                    return comparator.compare(input, operand) < 0;
                }
            };
        }
    }
    ,
    LESS_THAN_EQUALS("<="){

        @Override
        public <T> Predicate<T> getPredicateForValue(final Comparator<? super T> comparator, final T operand) {
            return new Predicate<T>(){

                @Override
                public boolean evaluate(T input) {
                    return comparator.compare(input, operand) <= 0;
                }
            };
        }
    }
    ,
    GREATER_THAN(">"){

        @Override
        public <T> Predicate<T> getPredicateForValue(final Comparator<? super T> comparator, final T operand) {
            return new Predicate<T>(){

                @Override
                public boolean evaluate(T input) {
                    return comparator.compare(input, operand) > 0;
                }
            };
        }
    }
    ,
    GREATER_THAN_EQUALS(">="){

        @Override
        public <T> Predicate<T> getPredicateForValue(final Comparator<? super T> comparator, final T value) {
            return new Predicate<T>(){

                @Override
                public boolean evaluate(T input) {
                    return comparator.compare(input, value) >= 0;
                }
            };
        }
    }
    ,
    WAS("was"){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            throw new IllegalStateException("You can not get a predicate for the 'was' operator.");
        }
    }
    ,
    WAS_NOT("was not"){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            throw new IllegalStateException("You can not get a predicate for the 'was not' operator.");
        }
    }
    ,
    WAS_IN("was in"){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            throw new IllegalStateException("You can not get a predicate for the 'was in' operator.");
        }
    }
    ,
    WAS_NOT_IN("was not in"){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            throw new IllegalStateException("You can not get a predicate for the 'was not in' operator.");
        }
    }
    ,
    CHANGED("changed"){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            throw new IllegalStateException("You can not get a predicate for the 'changed' operator.");
        }
    }
    ,
    NOT_CHANGED("not changed"){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            throw new IllegalStateException("You can not get a predicate for the 'not changed' operator.");
        }
    }
    ,
    BEFORE("before"){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            throw new IllegalStateException("You can not get a predicate for the 'before' operator.");
        }
    }
    ,
    AFTER("after"){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            throw new IllegalStateException("You can not get a predicate for the 'after' operator.");
        }
    }
    ,
    FROM("from"){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            throw new IllegalStateException("You can not get a predicate for the 'from' operator.");
        }
    }
    ,
    TO("to"){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            throw new IllegalStateException("You can not get a predicate for the 'to' operator.");
        }
    }
    ,
    ON("on"){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            throw new IllegalStateException("You can not get a predicate for the 'on' operator.");
        }
    }
    ,
    DURING("during"){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            throw new IllegalStateException("You can not get a predicate for the 'during' operator.");
        }
    }
    ,
    BY("by"){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            throw new IllegalStateException("You can not get a predicate for the 'by' operator.");
        }
    };

    private final String displayName;

    private Operator(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayString() {
        return this.displayName;
    }

    public abstract <T> Predicate<T> getPredicateForValue(Comparator<? super T> var1, T var2);
}

