/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.util;

import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.jira.issue.search.searchers.util.DateSearcherConfig;
import com.atlassian.jira.issue.search.searchers.util.DateSearcherInputHelper;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractDateSearchInputHelper
implements DateSearcherInputHelper {
    protected static final DateSearcherInputHelper.ConvertClauseResult CONVERT_CLAUSE_BAD_RESULT = new DateSearcherInputHelper.ConvertClauseResult(null, false);
    protected final DateSearcherConfig config;
    protected final JqlOperandResolver operandResolver;

    public AbstractDateSearchInputHelper(DateSearcherConfig config, JqlOperandResolver operandResolver) {
        this.config = Assertions.notNull("config", config);
        this.operandResolver = Assertions.notNull("notNull", operandResolver);
    }

    @Override
    public DateSearcherInputHelper.ConvertClauseResult convertClause(Clause clause, User user, boolean allowTimeComponent) {
        if (clause == null) {
            return CONVERT_CLAUSE_BAD_RESULT;
        }
        List<TerminalClause> clauseList = this.validateClauseStructure(clause);
        if (clauseList == null) {
            return CONVERT_CLAUSE_BAD_RESULT;
        }
        boolean fits = true;
        String afterValue = null;
        String beforeValue = null;
        String previousValue = null;
        String nextValue = null;
        for (TerminalClause terminalClause : clauseList) {
            ParseDateResult result;
            String date;
            Operand operand = terminalClause.getOperand();
            if (this.operandResolver.isEmptyOperand(operand)) {
                return CONVERT_CLAUSE_BAD_RESULT;
            }
            if (this.operandResolver.isFunctionOperand(operand)) {
                return CONVERT_CLAUSE_BAD_RESULT;
            }
            List<QueryLiteral> list = this.operandResolver.getValues(user, operand, terminalClause);
            if (list == null || list.size() != 1) {
                return CONVERT_CLAUSE_BAD_RESULT;
            }
            QueryLiteral dateLiteral = list.get(0);
            if (dateLiteral.isEmpty()) {
                return CONVERT_CLAUSE_BAD_RESULT;
            }
            Operator operator = terminalClause.getOperator();
            if (operator == Operator.LESS_THAN_EQUALS) {
                date = this.getValidNavigatorPeriod(dateLiteral);
                if (date != null) {
                    if (nextValue == null) {
                        nextValue = date;
                        continue;
                    }
                    return CONVERT_CLAUSE_BAD_RESULT;
                }
                result = this.getValidNavigatorDate(dateLiteral, allowTimeComponent);
                date = result.parsedDate;
                if (date != null) {
                    if (beforeValue == null) {
                        if (!result.fits) {
                            fits = false;
                        }
                        beforeValue = date;
                        continue;
                    }
                    return CONVERT_CLAUSE_BAD_RESULT;
                }
                return CONVERT_CLAUSE_BAD_RESULT;
            }
            if (operator == Operator.GREATER_THAN_EQUALS) {
                date = this.getValidNavigatorPeriod(dateLiteral);
                if (date != null) {
                    if (previousValue == null) {
                        previousValue = date;
                        continue;
                    }
                    return CONVERT_CLAUSE_BAD_RESULT;
                }
                result = this.getValidNavigatorDate(dateLiteral, allowTimeComponent);
                date = result.parsedDate;
                if (date != null) {
                    if (afterValue == null) {
                        if (!result.fits) {
                            fits = false;
                        }
                        afterValue = date;
                        continue;
                    }
                    return CONVERT_CLAUSE_BAD_RESULT;
                }
                return CONVERT_CLAUSE_BAD_RESULT;
            }
            return CONVERT_CLAUSE_BAD_RESULT;
        }
        Map<String, Object> fields = MapBuilder.newBuilder().addIfValueNotNull(this.config.getBeforeField(), beforeValue).addIfValueNotNull(this.config.getAfterField(), afterValue).addIfValueNotNull(this.config.getPreviousField(), previousValue).addIfValueNotNull(this.config.getNextField(), nextValue).toMap();
        return new DateSearcherInputHelper.ConvertClauseResult(fields, fits);
    }

    abstract ParseDateResult getValidNavigatorDate(QueryLiteral var1, boolean var2);

    private String getValidNavigatorPeriod(QueryLiteral dateLiteral) {
        if (StringUtils.isNotBlank((String)dateLiteral.getStringValue())) {
            try {
                DateUtils.getDurationWithNegative((String)dateLiteral.getStringValue());
                return dateLiteral.getStringValue();
            }
            catch (InvalidDurationException e) {
                return null;
            }
            catch (NumberFormatException ne) {
                return null;
            }
        }
        return null;
    }

    List<TerminalClause> validateClauseStructure(Clause clause) {
        SimpleNavigatorCollectorVisitor visitor = new SimpleNavigatorCollectorVisitor(this.config.getClauseNames());
        clause.accept(visitor);
        List<TerminalClause> clauses = visitor.getClauses();
        if (!visitor.isValid() || clauses.isEmpty()) {
            return null;
        }
        return clauses;
    }

    protected static class ParseDateResult {
        String parsedDate;
        boolean fits;

        ParseDateResult(boolean fits, String parsedDate) {
            this.fits = fits;
            this.parsedDate = parsedDate;
        }
    }
}

