/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.imports.project.customfield.NoTransformationCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.converters.StringConverterImpl;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractSingleFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.util.NotNull;

public class GenericTextCFType
extends AbstractSingleFieldType<String>
implements SortableCustomField<String>,
ProjectImportableCustomField {
    private ProjectCustomFieldImporter projectCustomFieldImporter = new NoTransformationCustomFieldImporter();

    protected GenericTextCFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager) {
        super(customFieldValuePersister, genericConfigManager);
    }

    @Override
    protected Object getDbValueFromObject(String customFieldObject) {
        return this.getStringFromSingularObject(customFieldObject);
    }

    @Override
    protected String getObjectFromDbValue(@NotNull Object databaseValue) throws FieldValidationException {
        return this.getSingularObjectFromString((String)databaseValue);
    }

    @Override
    public String getStringFromSingularObject(String value) {
        return StringConverterImpl.convertNullToEmpty(value);
    }

    @Override
    public String getSingularObjectFromString(String string) throws FieldValidationException {
        return string;
    }

    @Override
    @NotNull
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_LIMITED_TEXT;
    }

    @Override
    public int compare(@NotNull String customFieldObjectValue1, @NotNull String customFieldObjectValue2, FieldConfig fieldConfig) {
        return customFieldObjectValue1.compareTo(customFieldObjectValue2);
    }

    @Override
    public ProjectCustomFieldImporter getProjectImporter() {
        return this.projectCustomFieldImporter;
    }

    @Override
    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitString(this);
        }
        return super.accept(visitor);
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitString(GenericTextCFType var1);
    }
}

