/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.changehistory;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.user.UserUtils;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class ChangeHistory {
    private GenericValue changeHistory;
    private IssueManager issueManager;
    private List changeItems;
    private User user;

    public ChangeHistory(GenericValue changeHistoryGV, IssueManager issueManager) {
        this.changeHistory = changeHistoryGV;
        this.issueManager = issueManager;
    }

    public Long getId() {
        return this.changeHistory.getLong("id");
    }

    public String getUsername() {
        return this.changeHistory.getString("author");
    }

    public String getAuthor() {
        return this.changeHistory.getString("author");
    }

    public User getAuthorUser() {
        if (this.user == null) {
            this.user = UserUtils.getUserEvenWhenUnknown(this.getAuthor());
        }
        return this.user;
    }

    public String getAuthorDisplayName() {
        if (this.getAuthorUser() != null) {
            return this.getAuthorUser().getDisplayName();
        }
        return null;
    }

    public String getFullName() {
        return this.getAuthorDisplayName();
    }

    public Timestamp getTimePerformed() {
        return this.changeHistory.getTimestamp("created");
    }

    public String getLevel() {
        return this.changeHistory.getString("level");
    }

    public String getComment() {
        return this.changeHistory.getString("body");
    }

    public List getChangeItems() {
        if (this.changeItems == null) {
            try {
                this.changeItems = this.changeHistory.getRelated("ChildChangeItem");
            }
            catch (GenericEntityException e) {
                return Collections.EMPTY_LIST;
            }
        }
        return this.changeItems;
    }

    public Issue getIssue() {
        return this.issueManager.getIssueObject(this.changeHistory.getLong("issue"));
    }

    public Long getIssueId() {
        return this.changeHistory.getLong("issue");
    }
}

