/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.statistics.FilterStatisticsValuesGenerator;
import com.atlassian.jira.issue.statistics.util.DefaultFieldValueToDisplayTransformer;
import com.atlassian.jira.issue.statistics.util.ObjectToFieldValueMapper;
import com.atlassian.jira.util.I18nHelper;

public class PieSegmentWrapper
implements Comparable {
    private Object key;
    private String name;
    private boolean generateUrl;

    public PieSegmentWrapper(Object key, I18nHelper i18nHelper, String statisticType, ConstantsManager constantsManager, CustomFieldManager customFieldManager) {
        this.key = key;
        this.generateUrl = true;
        DefaultFieldValueToDisplayTransformer fieldValueToDisplayTransformer = new DefaultFieldValueToDisplayTransformer(i18nHelper, constantsManager, customFieldManager);
        if (key == FilterStatisticsValuesGenerator.IRRELEVANT) {
            this.key = null;
            this.generateUrl = false;
        }
        this.name = ObjectToFieldValueMapper.transform(statisticType, key, null, fieldValueToDisplayTransformer);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int compareTo(Object o) {
        return this.name.compareTo(((PieSegmentWrapper)o).name);
    }

    public Object getKey() {
        return this.key;
    }

    public boolean isGenerateUrl() {
        return this.generateUrl;
    }
}

