/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue;

import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import java.util.Collections;
import java.util.Set;

@PublicApi
public class MentionIssueEvent {
    private final Issue issue;
    private final User fromUser;
    private final Set<User> toUsers;
    private final String mentionText;
    private final String fieldId;

    public MentionIssueEvent(Issue issue, User fromUser, Set<User> toUsers, String mentionText, String fieldId) {
        this.issue = issue;
        this.fromUser = fromUser;
        this.toUsers = toUsers;
        this.mentionText = mentionText;
        this.fieldId = fieldId;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public User getFromUser() {
        return this.fromUser;
    }

    public Set<User> getToUsers() {
        return Collections.unmodifiableSet(this.toUsers);
    }

    public String getMentionText() {
        return this.mentionText;
    }

    public String getFieldId() {
        return this.fieldId;
    }
}

