package com.atlassian.jira.mention;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;

/**
 * Mention service to send notification e-mails to mentioned users.
 *
 * @since v5.0
 */
public interface MentionService
{
    /**
     * Given a comment object this method will look for any mentions using the {@link MentionFinder} and send e-mails to
     * all users mentioned.
     * <p/>
     * Sending mentions can not be performed by anonymous users.  The user sending the mentions must have browse users
     * permission and all users mentioned must have permission to browse the issue.  Otherwise no e-mails will be sent.
     *
     * @param remoteUser The currently logged in user performing this operation.
     * @param comment the comment to scan for text.
     * @param originalComment If a comment was edited provied the original comment so that a comparison can be carried out to only send mentions to new users. May be null
     */
    void sendCommentMentions(final User remoteUser, final Comment comment, final Comment originalComment);

    /**
     * Given an issue object this method will look for any mentions in the description field using the {@link MentionFinder} and send e-mails to
     * all users mentioned.
     * <p/>
     * Sending mentions can not be performed by anonymous users.  The user sending the mentions must have browse users
     * permission and all users mentioned must have permission to browse the issue.  Otherwise no e-mails will be sent.
     *
     * @param remoteUser The currently logged in user performing this operation.
     * @param issue the issue whose description will be scanned for metions.
     */
    void sendIssueMentions(final User remoteUser, final Issue issue);
}
