package com.atlassian.jira.issue.customfields.converters;

import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;

/**
 * Converts between User objects and Strings for storage and retrieval of Custom Field values.
 */
@PublicApi
public interface UserConverter
{

    public String getString(User user);

    /**
     * Get the User Object from the user name
     * @param stringValue
     * @return
     * @throws FieldValidationException
     */
    public User getUser(String stringValue) throws FieldValidationException;

    /**
     * Get the User Object from the user name
     * @param stringValue
     * @return
     * @throws FieldValidationException
     * @deprecated Use {@link #getUser(String)} instead. Since v5.0.
     */
    public User getUserObject(String stringValue) throws FieldValidationException;

}
