/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.datetime.LocalDateFactory;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.util.LuceneDirectoryUtils;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.annotation.concurrent.Immutable;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class LuceneUtils {
    private static final Logger log = Logger.getLogger(LuceneUtils.class);
    private static final DateFormatter dateFormatter = new DateFormatter();

    private LuceneUtils() {
    }

    public static IndexReader getIndexReader(String path) throws IndexException {
        try {
            LuceneDirectoryUtils luceneDirectoryUtils = ComponentAccessor.getComponent(LuceneDirectoryUtils.class);
            return IndexReader.open((Directory)luceneDirectoryUtils.getDirectory(new File(path)), (boolean)true);
        }
        catch (IOException e) {
            log.error((Object)("Problem with path " + path + ": " + e.getMessage()), (Throwable)e);
            throw new IndexException("Problem with path " + path + ": " + e.getMessage(), e);
        }
    }

    public static IndexWriter getIndexWriter(String path, boolean create, Analyzer analyzer) throws IndexException {
        try {
            LuceneDirectoryUtils luceneDirectoryUtils = ComponentAccessor.getComponent(LuceneDirectoryUtils.class);
            luceneDirectoryUtils.createDirRobust(path);
            IndexWriter indexWriter = new IndexWriter(luceneDirectoryUtils.getDirectory(new File(path)), analyzer, create, IndexWriter.MaxFieldLength.LIMITED);
            indexWriter.setUseCompoundFile(true);
            return indexWriter;
        }
        catch (IOException e) {
            log.error((Object)("Problem with path " + path + ": " + e.getMessage()), (Throwable)e);
            throw new IndexException("Problem with path " + path + ": " + e.getMessage(), e);
        }
    }

    public static String localDateToString(LocalDate localDate) {
        return LocalDateFactory.toIsoBasic(localDate);
    }

    public static LocalDate stringToLocalDate(String indexValue) {
        return LocalDateFactory.fromIsoBasicFormat(indexValue);
    }

    public static String dateToString(Date date) {
        return dateFormatter.dateToString(date, Resolution.SECOND);
    }

    public static Date stringToDate(String s) {
        if (s != null && s.trim().length() > 0) {
            return dateFormatter.stringToDate(s);
        }
        return new Date();
    }

    private static enum Resolution {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        MILLISECOND;

    }

    static class DateParsingException
    extends RuntimeException {
        public DateParsingException(String dateString) {
            super("Input is not valid date string: " + dateString);
        }
    }

    @Immutable
    static class DateFormatter {
        private final DateTimeFormatter year;
        private final DateTimeFormatter month;
        private final DateTimeFormatter day;
        private final DateTimeFormatter hour;
        private final DateTimeFormatter minute;
        private final DateTimeFormatter second;
        private final DateTimeFormatter millisecond;

        DateFormatter() {
            DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder(){

                public DateTimeFormatter toFormatter() {
                    return super.toFormatter().withZone(DateTimeZone.UTC);
                }
            };
            ISOChronology chronology = ISOChronology.getInstance();
            this.year = builder.appendYear(4, 4).toFormatter().withChronology((Chronology)chronology);
            this.month = builder.appendMonthOfYear(2).toFormatter().withChronology((Chronology)chronology);
            this.day = builder.appendDayOfMonth(2).toFormatter().withChronology((Chronology)chronology);
            this.hour = builder.appendHourOfDay(2).toFormatter().withChronology((Chronology)chronology);
            this.minute = builder.appendMinuteOfHour(2).toFormatter().withChronology((Chronology)chronology);
            this.second = builder.appendSecondOfMinute(2).toFormatter().withChronology((Chronology)chronology);
            this.millisecond = builder.appendMillisOfSecond(3).toFormatter().withChronology((Chronology)chronology);
        }

        public Date stringToDate(String dateString) throws DateParsingException {
            return this.stringToDateTime(dateString.trim()).toDate();
        }

        public DateTime stringToDateTime(String dateString) throws DateParsingException {
            switch (dateString.length()) {
                case 4: {
                    return this.year.parseDateTime(dateString);
                }
                case 6: {
                    return this.month.parseDateTime(dateString);
                }
                case 8: {
                    return this.day.parseDateTime(dateString);
                }
                case 10: {
                    return this.hour.parseDateTime(dateString);
                }
                case 12: {
                    return this.minute.parseDateTime(dateString);
                }
                case 14: {
                    return this.second.parseDateTime(dateString);
                }
                case 17: {
                    return this.millisecond.parseDateTime(dateString);
                }
            }
            throw new DateParsingException(dateString);
        }

        public String dateToString(Date date, Resolution resolution) {
            return this.timeToString(date.getTime(), resolution);
        }

        public String timeToString(long date, Resolution resolution) {
            switch (resolution) {
                case YEAR: {
                    return this.year.print(date);
                }
                case MONTH: {
                    return this.month.print(date);
                }
                case DAY: {
                    return this.day.print(date);
                }
                case HOUR: {
                    return this.hour.print(date);
                }
                case MINUTE: {
                    return this.minute.print(date);
                }
                case SECOND: {
                    return this.second.print(date);
                }
                case MILLISECOND: {
                    return this.millisecond.print(date);
                }
            }
            throw new IllegalArgumentException("unknown resolution " + (Object)((Object)resolution));
        }
    }
}

