/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.imports.project.customfield.GroupCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.GroupSelectorField;
import com.atlassian.jira.issue.customfields.converters.MultiGroupConverter;
import com.atlassian.jira.issue.customfields.converters.StringConverter;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractMultiCFType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.UserField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.util.GroupNameComparator;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class MultiGroupCFType
extends AbstractMultiCFType<Group>
implements GroupSelectorField,
ProjectImportableCustomField,
UserField {
    protected final MultiGroupConverter multiGroupConverter;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final FieldVisibilityManager fieldVisibilityManager;
    private static final Comparator<Group> NAME_COMPARATOR = new GroupNameComparator();
    private static final String MULTIPLE_PARAM_KEY = "multiple";
    private final GroupCustomFieldImporter groupCustomFieldImporter;

    public MultiGroupCFType(CustomFieldValuePersister customFieldValuePersister, StringConverter stringConverter, GenericConfigManager genericConfigManager, MultiGroupConverter multiGroupConverter, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, GroupManager groupManager, FieldVisibilityManager fieldVisibilityManager) {
        super(customFieldValuePersister, stringConverter, genericConfigManager);
        this.multiGroupConverter = multiGroupConverter;
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.groupCustomFieldImporter = new GroupCustomFieldImporter(groupManager);
    }

    @Override
    protected Comparator<Group> getTypeComparator() {
        return NAME_COMPARATOR;
    }

    @Override
    public Object getValueFromCustomFieldParams(CustomFieldParams parameters) throws FieldValidationException {
        HashSet groupSet = new HashSet();
        Collection values = parameters.getValuesForNullKey();
        if (values == null || values.isEmpty()) {
            return null;
        }
        Iterator i = values.iterator();
        while (i.hasNext()) {
            Collection<Object> groupNames = this.isMultiple() ? this.multiGroupConverter.extractGroupStringsFromString((String)i.next()) : EasyList.build(i.next());
            groupSet.addAll(this.convertStringsToTypes(groupNames));
        }
        ArrayList l = new ArrayList(groupSet);
        Collections.sort(l, NAME_COMPARATOR);
        return l;
    }

    @Override
    public Object getStringValueFromCustomFieldParams(CustomFieldParams parameters) {
        Collection groups = parameters.getValuesForNullKey();
        if (groups == null || groups.isEmpty()) {
            return null;
        }
        return this.putInvalidGroupsAtFront(groups);
    }

    @Override
    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        StringBuffer errors = new StringBuffer();
        for (String singleParam : relevantParams.getValuesForNullKey()) {
            Collection<Object> groupStrings = this.isMultiple() ? this.multiGroupConverter.extractGroupStringsFromString(singleParam) : EasyList.build((Object)singleParam);
            if (groupStrings == null) {
                return;
            }
            for (String string : groupStrings) {
                try {
                    this.multiGroupConverter.getGroup(string);
                }
                catch (FieldValidationException e) {
                    if (errors.length() > 0) {
                        errors.append(", ");
                    }
                    errors.append(string);
                }
            }
            if (errors == null || errors.length() <= 0) continue;
            String message = this.isMultiple() ? this.getI18nBean().getText("admin.errors.could.not.find.groupnames", errors) : this.getI18nBean().getText("admin.errors.could.not.find.groupname", errors);
            errorCollectionToAddTo.addError(config.getCustomField().getId(), message, ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    @Override
    public String getStringFromSingularObject(Object o) {
        return this.multiGroupConverter.getString((Group)o);
    }

    @Override
    public Object getSingularObjectFromString(String s) throws FieldValidationException {
        return this.multiGroupConverter.getGroup(s);
    }

    public List getRelatedIndexers(CustomField customField) {
        return EasyList.build((Object)new MultiGroupCustomFieldIndexer(this.fieldVisibilityManager, customField, this.multiGroupConverter));
    }

    @Override
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        Map<String, Object> params = super.getVelocityParameters(issue, field, fieldLayoutItem);
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.put("hasAdminPermission", this.permissionManager.hasPermission(0, this.authenticationContext.getUser()));
        params.put(MULTIPLE_PARAM_KEY, this.isMultiple());
        return params;
    }

    @Override
    protected String convertTypeToString(Object value) {
        return this.multiGroupConverter.getString((Group)value);
    }

    @Override
    protected Group convertStringToType(String string) {
        return this.multiGroupConverter.getGroup(string);
    }

    private Collection<String> putInvalidGroupsAtFront(Collection<String> groups) {
        HashSet<String> retSet = new HashSet<String>();
        StringBuffer errorString = new StringBuffer();
        if (groups != null) {
            for (String groupList : groups) {
                if (this.isMultiple()) {
                    for (String groupString : this.multiGroupConverter.extractGroupStringsFromString(groupList)) {
                        this.populateGroupString(groupString, retSet, errorString);
                    }
                    continue;
                }
                this.populateGroupString(groupList, retSet, errorString);
            }
        }
        ArrayList<String> l = new ArrayList<String>(retSet);
        Collections.sort(l);
        if (errorString.length() > 0) {
            l.add(0, errorString.toString());
        }
        return l;
    }

    private void populateGroupString(String groupString, Set<String> retSet, StringBuffer errorString) {
        try {
            this.multiGroupConverter.getGroup(groupString);
            retSet.add(groupString);
        }
        catch (FieldValidationException e) {
            if (errorString.length() > 0) {
                errorString.append(", ");
            }
            errorString.append(groupString);
        }
    }

    public boolean isMultiple() {
        return Boolean.valueOf((String)this.getDescriptor().getParams().get(MULTIPLE_PARAM_KEY));
    }

    @Override
    public ProjectCustomFieldImporter getProjectImporter() {
        return this.groupCustomFieldImporter;
    }

    @Override
    public Query getQueryForGroup(String fieldName, String groupName) {
        return new TermQuery(new Term(fieldName, groupName));
    }

    @Override
    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitMultiGroup(this);
        }
        return super.accept(visitor);
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitMultiGroup(MultiGroupCFType var1);
    }

    static class MultiGroupCustomFieldIndexer
    extends AbstractCustomFieldIndexer {
        private final CustomField customField;
        private final MultiGroupConverter multiGroupConverter;

        public MultiGroupCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, MultiGroupConverter multiGroupConverter) {
            super(fieldVisibilityManager, customField);
            this.customField = customField;
            this.multiGroupConverter = multiGroupConverter;
        }

        @Override
        public void addDocumentFieldsSearchable(Document doc, Issue issue) {
            this.addDocumentFields(doc, issue, Field.Index.NOT_ANALYZED);
        }

        @Override
        public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
            this.addDocumentFields(doc, issue, Field.Index.NO);
        }

        void addDocumentFields(Document doc, Issue issue, Field.Index indexType) {
            List o = (List)this.customField.getValue(issue);
            if (o != null) {
                for (Group group : o) {
                    doc.add((Fieldable)new Field(this.getDocumentFieldId(), this.multiGroupConverter.getString(group), Field.Store.YES, indexType));
                }
            }
        }
    }
}

