/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.context;

import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractJiraContext
implements JiraContextNode {
    private static final Logger log = Logger.getLogger(AbstractJiraContext.class);

    @Override
    public boolean isInContext(IssueContext issueContext) {
        boolean matches = true;
        if (issueContext != null) {
            if (this.getProject() != null) {
                matches = this.getProject().equals((Object)issueContext.getProject());
            }
            if (this.getIssueType() != null) {
                matches = this.getIssueType().equals((Object)issueContext.getIssueType());
            }
        } else {
            log.warn((Object)"The issue passed is null. Returning as a context match");
        }
        return matches;
    }

    public String toString() {
        GenericValue issueTypeGV;
        StringBuffer sb = new StringBuffer();
        GenericValue projectGV = this.getProject();
        if (projectGV != null) {
            sb.append("Project: ");
            sb.append(projectGV.getString("name"));
        }
        if ((issueTypeGV = this.getIssueType()) != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("Issue type: ");
            sb.append(issueTypeGV.getString("name"));
        }
        return sb.length() > 0 ? sb.toString() : "Global Context";
    }

    @Override
    public int compareTo(JiraContextNode o) {
        return new CompareToBuilder().append((Object)this.getProject(), (Object)o.getProject(), OfBizComparators.NAME_COMPARATOR).toComparison();
    }

    public boolean equals(Object o) {
        if (!(o instanceof JiraContextNode)) {
            return false;
        }
        JiraContextNode rhs = (JiraContextNode)o;
        return new EqualsBuilder().append((Object)this.getProject(), (Object)rhs.getProject()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(77, 127).append((Object)this.getProject()).toHashCode();
    }
}

