/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.model;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ofbiz.core.entity.GenericValue;

public class JiraHelper {
    private final HttpServletRequest request;
    private final Project project;
    private final Map<String, Object> params;

    public JiraHelper() {
        this(null);
    }

    public JiraHelper(HttpServletRequest request) {
        this(request, (Project)null);
    }

    public JiraHelper(HttpServletRequest request, Project project) {
        this(request, project, new HashMap<String, Object>());
    }

    public JiraHelper(HttpServletRequest request, Project project, Map<String, Object> params) {
        this.request = request;
        this.project = project;
        this.params = params;
    }

    @Deprecated
    public JiraHelper(HttpServletRequest request, GenericValue project) {
        this.request = request;
        this.project = project == null ? null : this.getProjectManager().getProjectObj(project.getLong("id"));
        this.params = new HashMap<String, Object>();
    }

    ProjectManager getProjectManager() {
        return ComponentAccessor.getProjectManager();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public Project getProjectObject() {
        return this.project;
    }

    @Deprecated
    public GenericValue getProject() {
        return this.project == null ? null : this.project.getGenericValue();
    }

    public String getQueryString() {
        if (this.project != null && this.project.getId() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("&amp;");
            sb.append(SystemSearchConstants.forProject().getUrlParameter());
            sb.append("=");
            sb.append(this.project.getId());
            return sb.toString();
        }
        return "";
    }

    public Map<String, Object> getContextParams() {
        Map<String, Project> newParams = MapBuilder.newBuilder().add("project", this.project).add("request", (Project)this.request).toMutableMap();
        return CompositeMap.of(newParams, this.params);
    }
}

