/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class URLCodec {
    private static final byte ESCAPE_CHAR = 37;
    private static final BitSet WWW_FORM_URL;
    private static final BitSet WWW_FORM_URL_SPACE_NOT_SAFE;

    public static byte[] encodeUrl(BitSet urlsafe, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (urlsafe == null) {
            urlsafe = WWW_FORM_URL;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i];
            if (b < 0) {
                b = 256 + b;
            }
            if (urlsafe.get(b)) {
                if (b == 32) {
                    b = 43;
                }
                buffer.write(b);
                continue;
            }
            buffer.write(37);
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            buffer.write(hex1);
            buffer.write(hex2);
        }
        return buffer.toByteArray();
    }

    public static byte[] decodeUrl(byte[] bytes) throws UnsupportedEncodingException {
        if (bytes == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == 43) {
                buffer.write(32);
                continue;
            }
            if (b == 37) {
                try {
                    int u = Character.digit((char)bytes[++i], 16);
                    int l = Character.digit((char)bytes[++i], 16);
                    if (u == -1 || l == -1) {
                        throw new UnsupportedEncodingException("Invalid URL encoding");
                    }
                    buffer.write((char)((u << 4) + l));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new UnsupportedEncodingException("Invalid URL encoding");
                }
            }
            buffer.write(b);
        }
        return buffer.toByteArray();
    }

    public static byte[] encode(byte[] bytes) {
        return URLCodec.encode(bytes, false);
    }

    public static byte[] encode(byte[] bytes, boolean withSpacesAsHexValue) {
        if (withSpacesAsHexValue) {
            return URLCodec.encodeUrl(WWW_FORM_URL_SPACE_NOT_SAFE, bytes);
        }
        return URLCodec.encodeUrl(WWW_FORM_URL, bytes);
    }

    public static byte[] decode(byte[] bytes) throws UnsupportedEncodingException {
        return URLCodec.decodeUrl(bytes);
    }

    public static String encode(String pString, String charset) throws UnsupportedEncodingException {
        return URLCodec.encode(pString, charset, false);
    }

    public static String encode(String pString, String charset, boolean withSpacesAsHexValue) throws UnsupportedEncodingException {
        if (pString == null) {
            return null;
        }
        return new String(URLCodec.encode(pString.getBytes(charset), withSpacesAsHexValue), "US-ASCII");
    }

    public static String encode(String pString) throws UnsupportedEncodingException {
        return URLCodec.encode(pString, false);
    }

    public static String encode(String pString, boolean withSpacesAsHexValue) throws UnsupportedEncodingException {
        if (pString == null) {
            return null;
        }
        return URLCodec.encode(pString, URLCodec.getDefaultCharset(), withSpacesAsHexValue);
    }

    public static String decode(String pString, String charset) throws UnsupportedEncodingException {
        if (pString == null) {
            return null;
        }
        return new String(URLCodec.decode(pString.getBytes("US-ASCII")), charset);
    }

    public static String decode(String pString) throws UnsupportedEncodingException {
        if (pString == null) {
            return null;
        }
        return URLCodec.decode(pString, URLCodec.getDefaultCharset());
    }

    public static Object encode(Object pObject) throws UnsupportedEncodingException {
        return URLCodec.encode(pObject, false);
    }

    public static Object encode(Object pObject, boolean withSpacesAsHexValue) throws UnsupportedEncodingException {
        if (pObject == null) {
            return null;
        }
        if (pObject instanceof byte[]) {
            return URLCodec.encode((byte[])pObject, withSpacesAsHexValue);
        }
        if (pObject instanceof String) {
            return URLCodec.encode((String)pObject, withSpacesAsHexValue);
        }
        throw new UnsupportedEncodingException("Objects of type " + pObject.getClass().getName() + " cannot be URL encoded");
    }

    public static Object decode(Object pObject) throws UnsupportedEncodingException {
        if (pObject == null) {
            return null;
        }
        if (pObject instanceof byte[]) {
            return URLCodec.decode((byte[])pObject);
        }
        if (pObject instanceof String) {
            return URLCodec.decode((String)pObject);
        }
        throw new UnsupportedEncodingException("Objects of type " + pObject.getClass().getName() + " cannot be URL decoded");
    }

    private static String getDefaultCharset() {
        ApplicationProperties appProps = ComponentAccessor.getApplicationProperties();
        return appProps.getEncoding();
    }

    static {
        int i;
        WWW_FORM_URL = new BitSet(256);
        WWW_FORM_URL_SPACE_NOT_SAFE = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            WWW_FORM_URL.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            WWW_FORM_URL.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            WWW_FORM_URL.set(i);
        }
        WWW_FORM_URL.set(45);
        WWW_FORM_URL.set(95);
        WWW_FORM_URL.set(46);
        WWW_FORM_URL.set(42);
        WWW_FORM_URL.set(32);
        WWW_FORM_URL_SPACE_NOT_SAFE.or(WWW_FORM_URL);
        WWW_FORM_URL_SPACE_NOT_SAFE.set(32, false);
    }
}

