/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.file;

import com.atlassian.annotations.Internal;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.service.AbstractService;
import com.atlassian.jira.service.util.ServiceUtils;
import com.atlassian.jira.service.util.handler.DefaultMessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandler;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerExecutionMonitor;
import com.atlassian.jira.service.util.handler.MessageHandlerFactory;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import java.util.Map;
import javax.annotation.Nullable;
import javax.mail.Message;
import org.apache.log4j.Logger;

@Internal
public abstract class AbstractMessageHandlingService
extends AbstractService {
    public static final String KEY_HANDLER = "handler";
    public static final String KEY_HANDLER_PARAMS = "handler.params";
    public static final int MAX_READ_MESSAGES_DRY_RUN = 10;
    protected volatile MessageHandler handler = null;
    private MessageHandlerContext context;

    public synchronized void setContext(MessageHandlerContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(PropertySet props) throws ObjectConfigurationException {
        block9: {
            super.init(props);
            try {
                String handlerClazz = this.getProperty(KEY_HANDLER);
                if (TextUtils.stringSet((String)handlerClazz)) {
                    MessageHandlerFactory messageHandlerFactory = ComponentAccessor.getOSGiComponentInstanceOfType(MessageHandlerFactory.class);
                    if (messageHandlerFactory == null) {
                        this.log.error((Object)"Cannot get MessageHandlerFactory. Perhaps your JIRA Mail Plugin is disabled or missing?");
                        return;
                    }
                    MessageHandler messageHandler = messageHandlerFactory.getHandler(handlerClazz);
                    if (messageHandler == null) {
                        this.log.error((Object)("Cannot instantiate message handler '" + handlerClazz + ". This service will not work until this problem is fixed."));
                        return;
                    }
                    try {
                        if (this.hasProperty(KEY_HANDLER_PARAMS)) {
                            Map<String, String> handlerParams = ServiceUtils.getParameterMap(this.getProperty(KEY_HANDLER_PARAMS));
                            messageHandler.init(handlerParams, this.getContext().getMonitor());
                        }
                        break block9;
                    }
                    finally {
                        this.handler = messageHandler;
                    }
                }
                this.log.error((Object)("You must specify a valid handler class for the " + this.getClass().getName() + " Service."));
            }
            catch (Exception e) {
                this.log.error((Object)("Could not create handler (" + this.getProperty(KEY_HANDLER) + ") - " + e), (Throwable)e);
            }
        }
    }

    private synchronized MessageHandlerContext getContext() {
        if (this.context == null) {
            this.context = new DefaultMessageHandlerContext(ComponentAccessor.getCommentManager(), new Log4jMessageHandlerExecutionMonitor(), ComponentAccessor.getIssueManager(), ComponentAccessor.getAttachmentManager());
        }
        return this.context;
    }

    protected abstract void runImpl(MessageHandlerContext var1);

    @Override
    public void run() {
        this.runImpl(this.getContext());
    }

    public MessageHandler getHandler() {
        return this.handler;
    }

    protected abstract String addHandlerInfo(String var1);

    protected abstract Logger getLogger();

    private class Log4jMessageHandlerExecutionMonitor
    implements MessageHandlerExecutionMonitor {
        private Log4jMessageHandlerExecutionMonitor() {
        }

        @Override
        public void setNumMessages(int count) {
        }

        @Override
        public void error(String error) {
            AbstractMessageHandlingService.this.getLogger().error((Object)AbstractMessageHandlingService.this.addHandlerInfo(error));
        }

        @Override
        public void info(String info) {
            AbstractMessageHandlingService.this.getLogger().info((Object)AbstractMessageHandlingService.this.addHandlerInfo(info));
        }

        @Override
        public void info(String info, @Nullable Throwable e) {
            AbstractMessageHandlingService.this.getLogger().info((Object)info, e);
        }

        @Override
        public void error(String error, @Nullable Throwable e) {
            AbstractMessageHandlingService.this.getLogger().error((Object)AbstractMessageHandlingService.this.addHandlerInfo(error), e);
        }

        @Override
        public void warning(String warning) {
            AbstractMessageHandlingService.this.getLogger().warn((Object)AbstractMessageHandlingService.this.addHandlerInfo(warning));
        }

        @Override
        public void messageRejected(Message message, String reason) {
            AbstractMessageHandlingService.this.getLogger().info((Object)("The message has been rejected: " + reason));
        }

        @Override
        public void nextMessage(Message message) {
        }

        @Override
        public void warning(String warning, @Nullable Throwable e) {
            AbstractMessageHandlingService.this.getLogger().warn((Object)AbstractMessageHandlingService.this.addHandlerInfo(warning), e);
        }
    }
}

