/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.JiraResourcedModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.atlassian.velocity.VelocityManager;
import com.opensymphony.util.TextUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public abstract class AbstractJiraModuleDescriptor<T>
extends AbstractModuleDescriptor<T>
implements JiraResourcedModuleDescriptor<T> {
    private String descriptionKey;
    private String i18nNameKey;
    private final ResettableLazyReference<T> moduleReference = new ResettableLazyReference<T>(){

        protected T create() throws Exception {
            return AbstractJiraModuleDescriptor.this.createModule();
        }
    };
    private final ModuleFactory moduleFactory;
    private final JiraAuthenticationContext authenticationContext;
    public static final String RESOURCE_TYPE_I18N = "i18n";
    private static final Logger log = Logger.getLogger(AbstractJiraModuleDescriptor.class);

    protected AbstractJiraModuleDescriptor(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        this.authenticationContext = authenticationContext;
        this.moduleFactory = moduleFactory;
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        Element descriptionEl = element.element("description");
        if (descriptionEl != null && descriptionEl.attribute("key") != null) {
            this.descriptionKey = descriptionEl.attributeValue("key");
        }
        this.i18nNameKey = element.attributeValue("i18n-name-key");
    }

    protected void assertResourceExists(String type, String name) throws PluginParseException {
        if (this.getResourceDescriptor(type, name) == null) {
            throw new PluginParseException("Resource with type: " + type + " and name " + name + " does not exist but should.");
        }
    }

    @Override
    public String getHtml(String resourceName) {
        return this.getHtml(resourceName, new HashMap());
    }

    @Override
    public String getHtml(String resourceName, Map<String, ?> startingParams) {
        ResourceDescriptor resource = this.getResourceDescriptor("velocity", resourceName);
        if (resource == null) {
            return null;
        }
        try {
            VelocityManager velocityManager = ComponentAccessor.getVelocityManager();
            Map<String, Object> velocityParams = this.createVelocityParams(startingParams);
            if (TextUtils.stringSet((String)resource.getLocation())) {
                return velocityManager.getEncodedBody(resource.getLocation(), "", ComponentAccessor.getApplicationProperties().getEncoding(), velocityParams);
            }
            return velocityManager.getEncodedBodyForContent(resource.getContent(), this.getBaseUrl(), velocityParams);
        }
        catch (Throwable e) {
            log.error((Object)("Error while rendering velocity template for '" + resourceName + "'."), e);
            return "";
        }
    }

    public T getModule() {
        return (T)this.moduleReference.get();
    }

    protected T createModule() {
        Object module = this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
        new GhettoInitter(module, this).maybeInit();
        return (T)module;
    }

    private String getBaseUrl() {
        return this.getVelocityRequestContextFactory().getJiraVelocityRequestContext().getBaseUrl();
    }

    private VelocityRequestContextFactory getVelocityRequestContextFactory() {
        return ComponentAccessor.getComponentOfType(VelocityRequestContextFactory.class);
    }

    public String getDescription() {
        if (this.descriptionKey != null) {
            return this.getI18nBean().getText(this.descriptionKey);
        }
        return super.getDescription();
    }

    public String getName() {
        if (this.i18nNameKey != null) {
            return this.getI18nBean().getText(this.i18nNameKey);
        }
        return super.getName();
    }

    protected JiraAuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    @Deprecated
    public String getText(String key) {
        return this.getI18nBean().getText(key);
    }

    public String getText(String key, Object params) {
        return this.getI18nBean().getText(key, params);
    }

    @Override
    public I18nHelper getI18nBean() {
        return this.authenticationContext.getI18nHelper();
    }

    protected Map<String, Object> createVelocityParams(Map<String, Object> startingParams) {
        Map<String, Object> params = this.getVelocityRequestContextFactory().getDefaultVelocityParams(startingParams, this.authenticationContext);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!params.containsKey(RESOURCE_TYPE_I18N)) {
            result.put(RESOURCE_TYPE_I18N, this.getI18nBean());
        }
        result.put("descriptor", this);
        return CompositeMap.of(result, params);
    }

    protected boolean isResourceExist(String resourceName) {
        return this.getResourceDescriptor("velocity", resourceName) != null;
    }

    protected ClassLoader getClassLoader() {
        return this.getPlugin().getClassLoader();
    }

    public void enabled() {
        super.enabled();
        this.moduleReference.reset();
    }

    public void disabled() {
        super.disabled();
        this.moduleReference.reset();
    }

    private class GhettoInitter {
        private final Object maybeNeedsInit;
        private final Object argumentForInit;

        public GhettoInitter(Object maybeNeedsInit, Object argumentForInit) {
            this.maybeNeedsInit = maybeNeedsInit;
            this.argumentForInit = argumentForInit;
        }

        public void maybeInit() {
            try {
                for (Method m : this.maybeNeedsInit.getClass().getMethods()) {
                    if (!m.getName().equals("init") || m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].isAssignableFrom(this.argumentForInit.getClass())) continue;
                    m.invoke(this.maybeNeedsInit, this.argumentForInit);
                    break;
                }
            }
            catch (IllegalAccessException e) {
                log.warn((Object)("Unable to instantiate module class: " + this.maybeNeedsInit.getClass()), (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                log.warn((Object)("Unable to instantiate module class: " + this.maybeNeedsInit.getClass()), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

