/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.util;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.issue.search.searchers.util.AbstractDateSearchInputHelper;
import com.atlassian.jira.issue.search.searchers.util.DateSearcherConfig;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.util.JqlLocalDateSupport;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class RelativeDateSearcherInputHelper
extends AbstractDateSearchInputHelper {
    private final JqlLocalDateSupport jqlLocalDateSupport;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    public RelativeDateSearcherInputHelper(DateSearcherConfig config, JqlOperandResolver operandResolver, JqlLocalDateSupport jqlLocalDateSupport, DateTimeFormatterFactory dateTimeFormatterFactory) {
        super(config, operandResolver);
        this.dateTimeFormatterFactory = Assertions.notNull("dateTimeFormatterFactory", dateTimeFormatterFactory);
        this.jqlLocalDateSupport = Assertions.notNull("jqlLocalDateSupport", jqlLocalDateSupport);
    }

    @Override
    AbstractDateSearchInputHelper.ParseDateResult getValidNavigatorDate(QueryLiteral dateLiteral, boolean allowTimeComponent) {
        LocalDate localDate;
        if (dateLiteral.getLongValue() != null) {
            localDate = this.jqlLocalDateSupport.convertToLocalDate(dateLiteral.getLongValue());
            if (localDate == null) {
                return new AbstractDateSearchInputHelper.ParseDateResult(true, dateLiteral.getLongValue().toString());
            }
        } else if (StringUtils.isNotBlank((String)dateLiteral.getStringValue())) {
            localDate = this.jqlLocalDateSupport.convertToLocalDate(dateLiteral.getStringValue());
            if (localDate == null) {
                return new AbstractDateSearchInputHelper.ParseDateResult(true, dateLiteral.getStringValue());
            }
        } else {
            return null;
        }
        Date date = this.jqlLocalDateSupport.convertToDate(localDate);
        String dateString = this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.DATE_PICKER).withSystemZone().format(date);
        return new AbstractDateSearchInputHelper.ParseDateResult(true, dateString);
    }
}

