/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.customfields.searchers.transformer.AbstractCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.searchers.transformer.NavigatorConversionResult;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import java.util.Collection;
import java.util.Collections;

public abstract class AbstractSingleValueCustomFieldSearchInputTransformer
extends AbstractCustomFieldSearchInputTransformer {
    private final ClauseNames clauseNames;

    public AbstractSingleValueCustomFieldSearchInputTransformer(CustomField field, ClauseNames clauseNames, String urlParameterName, CustomFieldInputHelper customFieldInputHelper) {
        super(field, urlParameterName, customFieldInputHelper);
        this.clauseNames = clauseNames;
    }

    @Override
    protected Clause getClauseFromParams(User searcher, CustomFieldParams customFieldParams) {
        Collection searchValues = customFieldParams.getAllValues();
        if (searchValues.size() == 1) {
            return this.createSearchClause(searcher, (String)searchValues.iterator().next());
        }
        return null;
    }

    @Override
    protected CustomFieldParams getParamsFromSearchRequest(User searcher, Query query, SearchContext searchContext) {
        NavigatorConversionResult result = this.convertForNavigator(query);
        if (result.fitsNavigator() && result.getValue() != null) {
            String stringValue = result.getValue().getStringValue() == null ? result.getValue().getLongValue().toString() : result.getValue().getStringValue();
            return new CustomFieldParamsImpl(this.getCustomField(), Collections.singleton(stringValue));
        }
        return null;
    }

    Clause createSearchClause(User searcher, String value) {
        return new TerminalClauseImpl(this.getClauseName(searcher, this.clauseNames), Operator.EQUALS, value);
    }

    NavigatorConversionResult convertForNavigator(Query query) {
        NavigatorConversionResult result;
        SimpleNavigatorCollectorVisitor collectorVisitor = this.createSimpleNavigatorCollectorVisitor();
        if (query != null && query.getWhereClause() != null) {
            query.getWhereClause().accept(collectorVisitor);
            result = !collectorVisitor.isValid() ? new NavigatorConversionResult(false, null) : (collectorVisitor.getClauses().isEmpty() ? new NavigatorConversionResult(true, null) : (collectorVisitor.getClauses().size() == 1 && this.checkOperand(collectorVisitor.getClauses().get(0).getOperator()) && collectorVisitor.getClauses().get(0).getOperand() instanceof SingleValueOperand ? new NavigatorConversionResult(true, (SingleValueOperand)collectorVisitor.getClauses().get(0).getOperand()) : new NavigatorConversionResult(false, null)));
        } else {
            result = new NavigatorConversionResult(true, null);
        }
        return result;
    }

    SimpleNavigatorCollectorVisitor createSimpleNavigatorCollectorVisitor() {
        return new SimpleNavigatorCollectorVisitor(this.clauseNames.getJqlFieldNames());
    }

    private boolean checkOperand(Operator operator) {
        return operator == Operator.EQUALS || operator == Operator.IS || operator == Operator.LIKE || operator == Operator.IN;
    }
}

