/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.preferences;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.core.util.PropertyUtils;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.HashSet;
import java.util.Set;

public class JiraUserPreferences
implements Preferences {
    private PropertySet backingPS = null;
    private final Set<String> defaultKeys = new HashSet<String>();

    public JiraUserPreferences() {
    }

    @Deprecated
    public JiraUserPreferences(com.opensymphony.user.User pUser) {
        this((User)pUser);
    }

    public JiraUserPreferences(User pUser) {
        if (pUser != null) {
            this.backingPS = ComponentAccessor.getUserPropertyManager().getPropertySet(pUser);
        }
    }

    public JiraUserPreferences(PropertySet userPs) {
        if (userPs != null) {
            this.backingPS = userPs;
        }
    }

    public long getLong(String key) {
        if (this.defaultKeys.contains(key)) {
            return Long.parseLong(this.getApplicationProperties().getDefaultBackedString(key));
        }
        if (this.backingPS != null && this.backingPS.exists(key)) {
            return this.backingPS.getLong(key);
        }
        this.defaultKeys.add(key);
        return Long.parseLong(this.getApplicationProperties().getDefaultBackedString(key));
    }

    public String getString(String key) {
        if (this.defaultKeys.contains(key)) {
            return this.getApplicationProperties().getDefaultBackedString(key);
        }
        if (this.backingPS != null && this.backingPS.exists(key)) {
            return this.backingPS.getString(key);
        }
        this.defaultKeys.add(key);
        return this.getApplicationProperties().getDefaultBackedString(key);
    }

    public boolean getBoolean(String key) {
        if (this.defaultKeys.contains(key)) {
            return this.getApplicationProperties().getOption(key);
        }
        if (this.backingPS != null && this.backingPS.exists(key)) {
            return this.backingPS.getBoolean(key);
        }
        this.defaultKeys.add(key);
        return this.getApplicationProperties().getOption(key);
    }

    public void setLong(String key, long i) throws AtlassianCoreException {
        if (this.backingPS == null) {
            throw new AtlassianCoreException("Trying to set a property on a null user this is not allowed");
        }
        this.defaultKeys.remove(key);
        this.backingPS.setLong(key, i);
    }

    public void setString(String key, String value) throws AtlassianCoreException {
        if (this.backingPS == null) {
            throw new AtlassianCoreException("Trying to set a property on a null user this is not allowed");
        }
        this.defaultKeys.remove(key);
        this.backingPS.setString(key, value);
    }

    public void setBoolean(String key, boolean b) throws AtlassianCoreException {
        if (this.backingPS == null) {
            throw new AtlassianCoreException("Trying to set a property on a null user this is not allowed");
        }
        this.defaultKeys.remove(key);
        this.backingPS.setBoolean(key, b);
    }

    public void remove(String key) throws AtlassianCoreException {
        if (this.backingPS == null) {
            throw new AtlassianCoreException("Trying to remove a property on a null user this is not allowed");
        }
        if (!this.backingPS.exists(key)) {
            throw new AtlassianCoreException("The property with key '" + key + "' does not exist.");
        }
        this.defaultKeys.remove(key);
        this.backingPS.remove(key);
    }

    ApplicationProperties getApplicationProperties() {
        return ComponentAccessor.getApplicationProperties();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JiraUserPreferences)) {
            return false;
        }
        JiraUserPreferences jiraUserPreferences = (JiraUserPreferences)o;
        if (this.backingPS == null) {
            return jiraUserPreferences.backingPS == null;
        }
        return PropertyUtils.identical((PropertySet)this.backingPS, (PropertySet)jiraUserPreferences.backingPS);
    }

    public int hashCode() {
        return this.backingPS != null ? this.backingPS.hashCode() : 0;
    }
}

