/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.i18n;

import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.i18n.I18nTranslationModeImpl;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class I18nTranslationModeSwitch {
    private static final String MAGIC_PARAMETER_NAME = "i18ntranslate";

    public void switchTranslationsMode(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        boolean turnItOn;
        String i18nTranslateStr = this.getMagicParameter(httpServletRequest);
        if (i18nTranslateStr != null) {
            turnItOn = this.parseBoolean(i18nTranslateStr);
        } else {
            Object sessionFlag = this.getSessionFlag(httpServletRequest);
            if (sessionFlag == null) {
                return;
            }
            turnItOn = true;
        }
        I18nTranslationModeImpl translationMode = new I18nTranslationModeImpl();
        if (turnItOn) {
            translationMode.setTranslationsModeOn(httpServletRequest, httpServletResponse);
            this.setSessionAttribute(httpServletRequest, Boolean.TRUE);
        } else {
            translationMode.setTranslationsModeOff();
            this.clearSessionAttribute(httpServletRequest);
        }
    }

    private String getMagicParameter(HttpServletRequest httpServletRequest) {
        Enumeration parameterNames = httpServletRequest.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String paramName = (String)parameterNames.nextElement();
            if (!MAGIC_PARAMETER_NAME.toLowerCase().equals(paramName)) continue;
            return httpServletRequest.getParameter(paramName);
        }
        return null;
    }

    private void clearSessionAttribute(HttpServletRequest httpServletRequest) {
        this.setSessionAttribute(httpServletRequest, null);
    }

    private void setSessionAttribute(HttpServletRequest httpServletRequest, Boolean flag) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            httpSession.setAttribute(this.getClass().getName(), (Object)flag);
        }
    }

    private Object getSessionFlag(HttpServletRequest httpServletRequest) {
        Object sessionFlag = null;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            sessionFlag = httpSession.getAttribute(this.getClass().getName());
        }
        return sessionFlag;
    }

    private boolean parseBoolean(@NotNull String i18nTranslateStr) {
        String lowerStr = i18nTranslateStr.toLowerCase();
        if ("on".equals(lowerStr)) {
            return true;
        }
        if ("off".equals(lowerStr)) {
            return false;
        }
        return Boolean.parseBoolean(i18nTranslateStr);
    }
}

