/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.keyboardshortcut;

import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public final class KeyboardShortcut
implements Comparable<KeyboardShortcut> {
    private final Set<List<String>> shortcuts;
    private final KeyboardShortcutManager.Context context;
    private final KeyboardShortcutManager.Operation operation;
    private final String parameter;
    private final String descriptionI18nKey;
    private final int order;
    private static final String START_TAG = "<kbd>";
    private static final String END_TAG = "</kbd>";
    private final boolean hidden;

    public KeyboardShortcut(KeyboardShortcutManager.Context context, KeyboardShortcutManager.Operation operation, String parameter, int order, Set<List<String>> shortcuts, String descriptionI18nKey, boolean hidden) {
        this.hidden = hidden;
        this.context = Assertions.notNull("context", context);
        this.shortcuts = new LinkedHashSet<List<String>>((Collection)Assertions.notNull("shortcuts", shortcuts));
        this.operation = Assertions.notNull("operation", operation);
        this.parameter = Assertions.notNull("parameter", parameter);
        this.order = order;
        this.descriptionI18nKey = descriptionI18nKey;
    }

    public KeyboardShortcutManager.Context getContext() {
        return this.context;
    }

    public Set<List<String>> getShortcuts() {
        return this.shortcuts;
    }

    public int getOrder() {
        return this.order;
    }

    public KeyboardShortcutManager.Operation getOperation() {
        return this.operation;
    }

    public String getParameter() {
        return this.parameter;
    }

    public String getDescriptionI18nKey() {
        return this.descriptionI18nKey;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getPrettyShortcut(I18nHelper i18nHelper) {
        StringBuilder ret = new StringBuilder();
        int count = 0;
        for (List<String> shortcut : this.shortcuts) {
            if (count > 0) {
                ret.append(" ").append(i18nHelper.getText("common.words.or")).append(" ");
            }
            if (shortcut.size() == 2) {
                ret.append(i18nHelper.getText("keyboard.shortcuts.two.keys", START_TAG + shortcut.get(0) + END_TAG, START_TAG + shortcut.get(1) + END_TAG));
            } else if (shortcut.size() == 3) {
                ret.append(i18nHelper.getText("keyboard.shortcuts.three.keys", START_TAG + shortcut.get(0) + END_TAG, START_TAG + shortcut.get(1) + END_TAG, START_TAG + shortcut.get(2) + END_TAG));
            } else {
                ret.append(START_TAG).append(StringUtils.join(shortcut, (String)" ")).append(END_TAG);
            }
            ++count;
        }
        return ret.toString();
    }

    @Override
    public int compareTo(KeyboardShortcut shortcut) {
        int order2 = shortcut.getOrder();
        if (this.order == order2) {
            return 0;
        }
        if (this.order < order2) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        return "KeyboardShortcut{context=" + (Object)((Object)this.context) + ", shortcuts=" + this.shortcuts + ", operation=" + (Object)((Object)this.operation) + ", parameter='" + this.parameter + '\'' + ", descriptionI18nKey='" + this.descriptionI18nKey + '\'' + ", order=" + this.order + ", hidden=" + this.hidden + '}';
    }
}

