/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.changehistory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@Immutable
public class ChangeHistoryItem
implements Comparable<ChangeHistoryItem> {
    private final Long id;
    private final Long changeGroupId;
    private final String user;
    private final String field;
    private final Long projectId;
    private final Long issueId;
    private final String issueKey;
    private final Timestamp created;
    private final Timestamp nextChangeCreated;
    private final Map<String, String> fromValues;
    private final Map<String, String> toValues;
    private static final Timestamp TS_MAX = new Timestamp(Long.MAX_VALUE);

    public ChangeHistoryItem(Long id, Long changeGroupId, Long projectId, Long issueId, String issueKey, String field, Timestamp created, String from, String to, String fromValue, String toValue, String user) {
        this(id, changeGroupId, projectId, issueId, issueKey, field, created, new Timestamp(Long.MAX_VALUE), from, to, fromValue, toValue, user);
    }

    public ChangeHistoryItem(Long id, Long changeGroupId, Long projectId, Long issueId, String issueKey, String field, Timestamp created, Timestamp nextChange, String from, String to, String fromValue, String toValue, String user) {
        this.fromValues = Maps.newHashMap();
        this.toValues = Maps.newHashMap();
        this.field = field;
        this.id = id;
        this.changeGroupId = changeGroupId;
        this.user = user;
        this.projectId = projectId;
        this.issueId = issueId;
        this.issueKey = issueKey;
        this.created = created;
        this.nextChangeCreated = nextChange;
        if (fromValue != null) {
            this.fromValues.put(fromValue, from == null ? "" : from);
        }
        if (toValue != null) {
            this.toValues.put(toValue, to == null ? "" : to);
        }
    }

    private ChangeHistoryItem(Long id, Long changeGroupId, Long projectId, Long issueId, String issueKey, String field, Timestamp created, Timestamp nextChange, Map<String, String> fromValues, Map<String, String> toValues, String user) {
        this.fromValues = fromValues;
        this.toValues = toValues;
        this.id = id;
        this.changeGroupId = changeGroupId;
        this.user = user;
        this.projectId = projectId;
        this.issueId = issueId;
        this.issueKey = issueKey;
        this.created = created;
        this.nextChangeCreated = nextChange;
        this.field = field;
    }

    public Long getId() {
        return this.id;
    }

    public Long getChangeGroupId() {
        return this.changeGroupId;
    }

    public String getUser() {
        return this.user;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public Long getIssueId() {
        return this.issueId;
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public Timestamp getCreated() {
        return this.created;
    }

    public Map<String, String> getFroms() {
        return ImmutableMap.copyOf(this.fromValues);
    }

    public Map<String, String> getTos() {
        return ImmutableMap.copyOf(this.toValues);
    }

    public String getField() {
        return this.field;
    }

    public Timestamp getNextChangeCreated() {
        return this.nextChangeCreated;
    }

    public Long getDuration() {
        if (this.nextChangeCreated.equals(TS_MAX)) {
            return -1L;
        }
        return this.nextChangeCreated.getTime() - this.created.getTime();
    }

    public boolean containsFromValue(String fromValue) {
        return this.fromValues.keySet().contains(fromValue);
    }

    public boolean containsToValue(String toValue) {
        return this.toValues.keySet().contains(toValue);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ChangeHistoryItem)) {
            return false;
        }
        ChangeHistoryItem rhs = (ChangeHistoryItem)o;
        return new EqualsBuilder().append((Object)this.getId(), (Object)rhs.getId()).append((Object)this.getChangeGroupId(), (Object)rhs.getChangeGroupId()).append((Object)this.getField(), (Object)rhs.getField()).append((Object)this.getUser(), (Object)rhs.getUser()).append((Object)this.getProjectId(), (Object)rhs.getProjectId()).append((Object)this.getIssueId(), (Object)rhs.getIssueId()).append((Object)this.getIssueKey(), (Object)rhs.getIssueKey()).append((Object)this.getCreated(), (Object)rhs.getCreated()).append((Object)this.getNextChangeCreated(), (Object)rhs.getNextChangeCreated()).append(this.getFroms(), rhs.getFroms()).append(this.getTos(), rhs.getTos()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getId()).append((Object)this.getChangeGroupId()).append((Object)this.getField()).append((Object)this.getUser()).append((Object)this.getProjectId()).append((Object)this.getIssueId()).append((Object)this.getIssueKey()).append((Object)this.getCreated()).append((Object)this.getNextChangeCreated()).append(this.getFroms()).append(this.getTos()).toHashCode();
    }

    @Override
    public int compareTo(ChangeHistoryItem other) {
        if (this.changeGroupId.compareTo(this.changeGroupId) == 0) {
            return this.id.compareTo(other.getId());
        }
        return this.created.compareTo(other.getCreated());
    }

    public static class Builder {
        private long id;
        private long changeGroupId;
        private long projectId;
        private long issueId;
        private String issueKey;
        private String field;
        private Timestamp created;
        private Map<String, String> fromValue = Maps.newHashMap();
        private Map<String, String> toValue = Maps.newHashMap();
        private String userName;
        private Timestamp nextChangeCreated = new Timestamp(Long.MAX_VALUE);

        public Builder fromChangeItem(ChangeHistoryItem changeItem) {
            this.fromChangeItemWithoutPreservingChanges(changeItem);
            this.fromValue = Maps.newHashMap(changeItem.getFroms());
            this.toValue = Maps.newHashMap(changeItem.getTos());
            return this;
        }

        public Builder fromChangeItemWithoutPreservingChanges(ChangeHistoryItem changeItem) {
            this.id = changeItem.getId();
            this.projectId = changeItem.getProjectId();
            this.changeGroupId = changeItem.getChangeGroupId();
            this.issueId = changeItem.getIssueId();
            this.issueKey = changeItem.getIssueKey();
            this.field = changeItem.getField();
            this.created = changeItem.getCreated();
            this.userName = changeItem.getUser();
            this.nextChangeCreated = changeItem.getNextChangeCreated();
            return this;
        }

        public Builder fromChangeItemPreservingFromValues(ChangeHistoryItem changeItem) {
            this.fromChangeItemWithoutPreservingChanges(changeItem);
            this.fromValue = Maps.newHashMap(changeItem.getFroms());
            return this;
        }

        public Builder fromChangeItemPreservingToValues(ChangeHistoryItem changeItem) {
            this.fromChangeItemWithoutPreservingChanges(changeItem);
            this.toValue = Maps.newHashMap(changeItem.getTos());
            return this;
        }

        public Builder withId(long id) {
            this.id = id;
            return this;
        }

        public Builder inChangeGroup(long id) {
            Preconditions.checkNotNull((Object)id);
            this.changeGroupId = id;
            return this;
        }

        public Builder inProject(long projectId) {
            Preconditions.checkNotNull((Object)projectId);
            this.projectId = projectId;
            return this;
        }

        public Builder forIssue(long issueId, String issueKey) {
            Preconditions.checkNotNull((Object)issueId);
            Preconditions.checkNotNull((Object)issueKey);
            this.issueId = issueId;
            this.issueKey = issueKey;
            return this;
        }

        public Builder field(String field) {
            Preconditions.checkNotNull((Object)field);
            this.field = field;
            return this;
        }

        public Builder changedFrom(String from, String fromValue) {
            if (fromValue != null) {
                this.fromValue.put(fromValue, from == null ? "" : from);
            }
            return this;
        }

        public Builder to(String to, String toValue) {
            if (toValue != null) {
                this.toValue.put(toValue, to == null ? "" : to);
            }
            return this;
        }

        public Builder byUser(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder on(Timestamp created) {
            Preconditions.checkNotNull((Object)created);
            this.created = created;
            return this;
        }

        public Builder nextChangeOn(Timestamp nextChangeCreated) {
            this.nextChangeCreated = nextChangeCreated;
            return this;
        }

        public Builder withTos(Map<String, String> tos) {
            this.toValue = Maps.newHashMap(tos);
            return this;
        }

        public Builder withFroms(Map<String, String> froms) {
            this.fromValue = Maps.newHashMap(froms);
            return this;
        }

        public ChangeHistoryItem build() {
            return new ChangeHistoryItem((Long)this.id, (Long)this.changeGroupId, (Long)this.projectId, (Long)this.issueId, this.issueKey, this.field, this.created, this.nextChangeCreated, this.fromValue, this.toValue, this.userName);
        }
    }
}

