package com.atlassian.jira.bc.issue.worklog;

/**
 * <p>A more-specific class of {@link WorklogInputParameters} required to validate and perform worklog creation and
 * update service calls which additionally set the remaining estimate to a new estimate.
 *
 * <p>To build instances of this class, see the {@link com.atlassian.jira.bc.issue.worklog.WorklogInputParametersImpl}
 * builder methods. Moreover, you must use the correct <code>build</code> method to get the right return type.
 *
 * @since v4.2
 * @see WorklogInputParametersImpl#builder()
 * @see WorklogInputParametersImpl#issue(com.atlassian.jira.issue.Issue)
 * @see WorklogInputParametersImpl#timeSpent(String)
 * @see WorklogInputParametersImpl.Builder#buildNewEstimate()
 */
public interface WorklogNewEstimateInputParameters extends WorklogInputParameters
{
    /**
     * @return The value to change the issue's remaining estimate to.
     */
    String getNewEstimate();
}