/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.worklog;

import com.atlassian.jira.bc.issue.worklog.WorklogAdjustmentAmountResult;
import com.atlassian.jira.bc.issue.worklog.WorklogNewEstimateResult;
import com.atlassian.jira.bc.issue.worklog.WorklogResult;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.util.dbc.Assertions;

public class WorklogResultFactory {
    public static WorklogResult create(Worklog worklog) {
        return WorklogResultFactory.create(worklog, true);
    }

    public static WorklogResult create(Worklog worklog, boolean isEditableCheckRequired) {
        return new WorklogResultImpl(worklog, isEditableCheckRequired, null, null);
    }

    public static WorklogNewEstimateResult createNewEstimate(WorklogResult worklogResult, Long newEstimate) {
        Assertions.notNull("worklogResult", worklogResult);
        return WorklogResultFactory.createNewEstimate(worklogResult.getWorklog(), newEstimate, worklogResult.isEditableCheckRequired());
    }

    public static WorklogNewEstimateResult createNewEstimate(Worklog worklog, Long newEstimate) {
        return WorklogResultFactory.createNewEstimate(worklog, newEstimate, true);
    }

    public static WorklogNewEstimateResult createNewEstimate(Worklog worklog, Long newEstimate, boolean isEditableCheckRequired) {
        return new WorklogResultImpl(worklog, isEditableCheckRequired, newEstimate, null);
    }

    public static WorklogAdjustmentAmountResult createAdjustmentAmount(WorklogResult worklogResult, Long adjustmentAmount) {
        Assertions.notNull("worklogResult", worklogResult);
        return WorklogResultFactory.createAdjustmentAmount(worklogResult.getWorklog(), adjustmentAmount, worklogResult.isEditableCheckRequired());
    }

    public static WorklogAdjustmentAmountResult createAdjustmentAmount(Worklog worklog, Long adjustmentAmount) {
        return WorklogResultFactory.createAdjustmentAmount(worklog, adjustmentAmount, true);
    }

    public static WorklogAdjustmentAmountResult createAdjustmentAmount(Worklog worklog, Long adjustmentAmount, boolean isEditableCheckRequired) {
        return new WorklogResultImpl(worklog, isEditableCheckRequired, null, adjustmentAmount);
    }

    private static class WorklogResultImpl
    implements WorklogResult,
    WorklogNewEstimateResult,
    WorklogAdjustmentAmountResult {
        private final Worklog worklog;
        private final Long newEstimate;
        private final Long adjustmentAmount;
        private final boolean editableCheckRequired;

        private WorklogResultImpl(Worklog worklog, boolean editableCheckRequired, Long newEstimate, Long adjustmentAmount) {
            this.adjustmentAmount = adjustmentAmount;
            this.newEstimate = newEstimate;
            this.worklog = worklog;
            this.editableCheckRequired = editableCheckRequired;
        }

        @Override
        public Long getAdjustmentAmount() {
            return this.adjustmentAmount;
        }

        @Override
        public Long getNewEstimate() {
            return this.newEstimate;
        }

        @Override
        public Worklog getWorklog() {
            return this.worklog;
        }

        @Override
        public boolean isEditableCheckRequired() {
            return this.editableCheckRequired;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WorklogResultImpl that = (WorklogResultImpl)o;
            if (this.editableCheckRequired != that.editableCheckRequired) {
                return false;
            }
            if (this.adjustmentAmount != null ? !this.adjustmentAmount.equals(that.adjustmentAmount) : that.adjustmentAmount != null) {
                return false;
            }
            if (this.newEstimate != null ? !this.newEstimate.equals(that.newEstimate) : that.newEstimate != null) {
                return false;
            }
            return !(this.worklog != null ? !this.worklog.equals(that.worklog) : that.worklog != null);
        }

        public int hashCode() {
            int result = this.worklog != null ? this.worklog.hashCode() : 0;
            result = 31 * result + (this.newEstimate != null ? this.newEstimate.hashCode() : 0);
            result = 31 * result + (this.adjustmentAmount != null ? this.adjustmentAmount.hashCode() : 0);
            result = 31 * result + (this.editableCheckRequired ? 1 : 0);
            return result;
        }
    }
}

