/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.link;

import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.ofbiz.AbstractOfBizValueWrapper;
import org.ofbiz.core.entity.GenericValue;

public class IssueLink
extends AbstractOfBizValueWrapper {
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueManager issueManager;
    private IssueLinkType issueLinkType;
    static final String LINK_TYPE_ID_FIELD_NAME = "linktype";
    static final String SOURCE_ID_FIELD_NAME = "source";
    static final String DESTINATION_ID_LINK_NAME = "destination";
    static final String SEQUENCE_FIELD_NAME = "sequence";

    public IssueLink(GenericValue genericValue, IssueLinkTypeManager issueLinkTypeManager, IssueManager issueManager) {
        super(genericValue);
        this.issueManager = issueManager;
        if (!"IssueLink".equals(genericValue.getEntityName())) {
            throw new IllegalArgumentException("Entity must be an 'IssueLink', not '" + genericValue.getEntityName() + "'.");
        }
        this.issueLinkTypeManager = issueLinkTypeManager;
    }

    public Long getId() {
        return this.getGenericValue().getLong("id");
    }

    public Long getLinkTypeId() {
        return this.getGenericValue().getLong(LINK_TYPE_ID_FIELD_NAME);
    }

    public Long getSourceId() {
        return this.getGenericValue().getLong(SOURCE_ID_FIELD_NAME);
    }

    public Long getDestinationId() {
        return this.getGenericValue().getLong(DESTINATION_ID_LINK_NAME);
    }

    public Long getSequence() {
        return this.getGenericValue().getLong(SEQUENCE_FIELD_NAME);
    }

    void setSequence(Long sequence) {
        this.getGenericValue().set(SEQUENCE_FIELD_NAME, (Object)sequence);
    }

    void setIssueLinkType(IssueLinkType issueLinkType) {
        if (issueLinkType == null) {
            throw new IllegalArgumentException("Cannot set link type to null.");
        }
        this.getGenericValue().set(LINK_TYPE_ID_FIELD_NAME, (Object)issueLinkType.getId());
    }

    public IssueLinkType getIssueLinkType() {
        if (this.issueLinkType == null) {
            this.issueLinkType = this.issueLinkTypeManager.getIssueLinkType(this.getLinkTypeId());
        }
        return this.issueLinkType;
    }

    public MutableIssue getSourceObject() {
        return this.getIssueObject(this.getSourceId());
    }

    public MutableIssue getDestinationObject() {
        return this.getIssueObject(this.getDestinationId());
    }

    public boolean isSystemLink() {
        return this.getIssueLinkType().isSystemLinkType();
    }

    public GenericValue getSource() {
        return this.getIssue(this.getSourceId());
    }

    public GenericValue getDestination() {
        return this.getIssue(this.getDestinationId());
    }

    private GenericValue getIssue(Long issueId) {
        return this.issueManager.getIssue(issueId);
    }

    private MutableIssue getIssueObject(Long issueId) {
        return this.issueManager.getIssueObject(issueId);
    }
}

