/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.ErrorCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SimpleErrorCollection
implements ErrorCollection {
    Map<String, String> errors = new HashMap<String, String>(2);
    List<String> errorMessages = new LinkedList<String>();

    @Override
    public void addError(String field, String message) {
        this.errors.put(field, message);
    }

    @Override
    public void addErrorMessage(String message) {
        this.errorMessages.add(message);
    }

    @Override
    public Collection<String> getErrorMessages() {
        return this.errorMessages;
    }

    @Override
    public void setErrorMessages(Collection<String> errorMessages) {
        this.errorMessages = new ArrayList<String>(errorMessages);
    }

    @Override
    public Collection<String> getFlushedErrorMessages() {
        Collection<String> errors = this.getErrorMessages();
        this.errorMessages = new ArrayList<String>();
        return errors;
    }

    @Override
    public Map<String, String> getErrors() {
        return this.errors;
    }

    @Override
    public void addErrorCollection(ErrorCollection errors) {
        this.addErrorMessages(errors.getErrorMessages());
        this.addErrors(errors.getErrors());
    }

    @Override
    public void addErrorMessages(Collection<String> incomingMessages) {
        if (incomingMessages != null && !incomingMessages.isEmpty()) {
            for (String incomingMessage : incomingMessages) {
                this.addErrorMessage(incomingMessage);
            }
        }
    }

    @Override
    public void addErrors(Map<String, String> incomingErrors) {
        if (incomingErrors == null) {
            return;
        }
        for (Map.Entry<String, String> mapEntry : incomingErrors.entrySet()) {
            this.addError(mapEntry.getKey(), mapEntry.getValue());
        }
    }

    @Override
    public boolean hasAnyErrors() {
        return this.errors != null && !this.errors.isEmpty() || this.errorMessages != null && !this.errorMessages.isEmpty();
    }

    public String toString() {
        return "Errors: " + this.getErrors() + "\n" + "Error Messages: " + this.getErrorMessages();
    }

    public int hashCode() {
        int result = ((Object)this.errors).hashCode();
        result = 29 * result + ((Object)this.errorMessages).hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleErrorCollection that = (SimpleErrorCollection)o;
        if (!((Object)this.errorMessages).equals(that.errorMessages)) {
            return false;
        }
        return ((Object)this.errors).equals(that.errors);
    }
}

