/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.customfield;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public final class CustomFieldInstanceDefinition {
    private final String key;
    private final String name;
    private final String description;

    private CustomFieldInstanceDefinition(String key, String name, String description) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.description = (String)Preconditions.checkNotNull((Object)description);
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CustomFieldInstanceDefinition data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomFieldInstanceDefinition that = (CustomFieldInstanceDefinition)o;
        return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDescription(), that.getDescription());
    }

    public int hashCode() {
        return Objects.hash(this.getKey(), this.getName(), this.getDescription());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.getKey()).add("name", (Object)this.getName()).add("description", (Object)this.getDescription()).toString();
    }

    public static final class Builder {
        private String key;
        private String name;
        private String description;

        private Builder() {
        }

        private Builder(CustomFieldInstanceDefinition initialData) {
            this.key = initialData.getKey();
            this.name = initialData.getName();
            this.description = initialData.getDescription();
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public CustomFieldInstanceDefinition build() {
            return new CustomFieldInstanceDefinition(this.key, this.name, this.description);
        }
    }
}

