/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.VersionIndexInfoResolver;
import com.atlassian.jira.jql.validator.ValuesExistValidator;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MultiMap;
import com.atlassian.jira.util.collect.MultiMaps;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Longs;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class VersionValuesExistValidator
extends ValuesExistValidator {
    private final VersionIndexInfoResolver versionIndexInfoResolver;
    private final PermissionManager permissionManager;
    private final VersionManager versionManager;

    VersionValuesExistValidator(JqlOperandResolver operandResolver, VersionIndexInfoResolver versionIndexInfoResolver, PermissionManager permissionManager, VersionManager versionManager, I18nHelper.BeanFactory beanFactory) {
        super(operandResolver, beanFactory);
        this.versionIndexInfoResolver = Assertions.notNull("versionIndexInfoResolver", versionIndexInfoResolver);
        this.permissionManager = Assertions.notNull("permissionManager", permissionManager);
        this.versionManager = Assertions.notNull("versionManager", versionManager);
    }

    @Override
    boolean stringValueExists(ApplicationUser searcher, String value) {
        List<String> ids = this.versionIndexInfoResolver.getIndexedValues(value);
        return this.versionExists(searcher, ids);
    }

    @Override
    boolean longValueExist(ApplicationUser searcher, Long value) {
        List<String> ids = this.versionIndexInfoResolver.getIndexedValues(value);
        return this.versionExists(searcher, ids);
    }

    boolean versionExists(ApplicationUser searcher, List<String> ids) {
        for (String sid : ids) {
            Version version;
            Long id = Longs.tryParse((String)sid);
            if (id == null || (version = this.versionManager.getVersion(id)) == null || !this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, version.getProjectObject(), searcher)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Set<Long> longValuesExist(ApplicationUser searcher, final List<Long> values) {
        Multimap existingIds = (Multimap)this.versionManager.getVersions(values).stream().filter(Objects::nonNull).collect(CollectorsUtil.toUnmodifiableSetMultiMap(Version::getId, ver -> ver));
        LazyReference<Multimap<String, Version>> idsToNames = new LazyReference<Multimap<String, Version>>(){

            protected Multimap<String, Version> create() throws Exception {
                return VersionValuesExistValidator.this.versionManager.getVersionsForNames(values.stream().map(Object::toString).collect(Collectors.toList()));
            }
        };
        return this.process(values, existingIds, idsToNames, Object::toString, searcher);
    }

    @Override
    protected Set<String> stringValuesExist(ApplicationUser searcher, final List<String> values) {
        Multimap<String, Version> idsToNames = this.versionManager.getVersionsForNames(values);
        LazyReference<Multimap<Long, Version>> existingIds = new LazyReference<Multimap<Long, Version>>(){

            protected Multimap<Long, Version> create() throws Exception {
                return (Multimap)VersionValuesExistValidator.this.versionManager.getVersions(values.stream().map(Longs::tryParse).filter(Objects::nonNull).collect(Collectors.toList())).stream().filter(Objects::nonNull).collect(CollectorsUtil.toUnmodifiableSetMultiMap(Version::getId, ver -> ver));
            }
        };
        return this.process(values, idsToNames, existingIds, Longs::tryParse, searcher);
    }

    private <T, U> Set<T> process(List<T> values, Multimap<T, Version> lookupMap, LazyReference<Multimap<U, Version>> backupLookupMap, Function<T, U> backupTransformer, ApplicationUser searcher) {
        MultiMap projectVersionMap = MultiMaps.createListMultiMap();
        values.stream().forEach(value -> {
            Collection versions = lookupMap.get(value);
            if (versions == null || versions.isEmpty()) {
                versions = Optional.ofNullable(((Multimap)backupLookupMap.get()).get(backupTransformer.get(value))).orElse(Collections.emptyList());
            }
            versions.forEach(v -> projectVersionMap.putSingle(v.getProject(), value));
        });
        return projectVersionMap.entrySet().stream().filter(entry -> this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, (Project)entry.getKey(), searcher)).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

