/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.annotations.PublicSpi;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@PublicSpi
public interface NameResolver<T> {
    public List<String> getIdsFromName(String var1);

    default public Multimap<String, String> getIdsFromNames(Collection<String> names) {
        LinkedHashMultimap map = LinkedHashMultimap.create((int)names.size(), (int)1);
        names.stream().distinct().forEach(name -> this.getIdsFromName((String)name).stream().forEach(id -> map.put(name, id)));
        return Multimaps.unmodifiableMultimap((Multimap)map);
    }

    default public Set<Long> getExistingIds(Collection<Long> ids) {
        return ids.stream().filter(this::idExists).collect(Collectors.toSet());
    }

    public boolean nameExists(String var1);

    public boolean idExists(Long var1);

    public T get(Long var1);

    @Nonnull
    public Collection<T> getAll();
}

