/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.operand;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.Operand;

public class QueryLiteral {
    public static final QueryLiteral EMPTY = new QueryLiteral();
    private final String stringValue;
    private final Long longValue;
    private final Operand sourceOperand;

    public QueryLiteral() {
        this.sourceOperand = EmptyOperand.EMPTY;
        this.stringValue = null;
        this.longValue = null;
    }

    public QueryLiteral(Operand sourceOperand) {
        this.sourceOperand = Assertions.notNull("sourceOperand", sourceOperand);
        this.stringValue = null;
        this.longValue = null;
    }

    public QueryLiteral(Operand sourceOperand, Long longValue) {
        this.sourceOperand = Assertions.notNull("sourceOperand", sourceOperand);
        this.stringValue = null;
        this.longValue = longValue;
    }

    public QueryLiteral(Operand sourceOperand, String stringValue) {
        this.sourceOperand = Assertions.notNull("sourceOperand", sourceOperand);
        this.stringValue = stringValue;
        this.longValue = null;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public Long getLongValue() {
        return this.longValue;
    }

    public Operand getSourceOperand() {
        return this.sourceOperand;
    }

    public boolean isEmpty() {
        return this.stringValue == null && this.longValue == null;
    }

    public String asString() {
        if (this.longValue != null) {
            return this.longValue.toString();
        }
        return this.stringValue;
    }

    public String toString() {
        return this.longValue != null ? this.longValue.toString() : String.valueOf(this.stringValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryLiteral that = (QueryLiteral)o;
        if (this.longValue != null ? !this.longValue.equals(that.longValue) : that.longValue != null) {
            return false;
        }
        return !(this.stringValue != null ? !this.stringValue.equals(that.stringValue) : that.stringValue != null);
    }

    public int hashCode() {
        int result = this.stringValue != null ? this.stringValue.hashCode() : 0;
        result = 31 * result + (this.longValue != null ? this.longValue.hashCode() : 0);
        return result;
    }
}

