/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.jql.context.AllIssueTypesContext;
import com.atlassian.jira.jql.context.AllProjectsContext;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.IssueTypeContext;
import com.atlassian.jira.jql.context.IssueTypeContextImpl;
import com.atlassian.jira.jql.context.ProjectContext;
import com.atlassian.jira.jql.context.ProjectContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.InjectableComponent;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InjectableComponent
public class FieldConfigSchemeClauseContextUtil {
    private static final Logger log = LoggerFactory.getLogger(FieldConfigSchemeClauseContextUtil.class);
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final PermissionManager permissionManager;

    @Deprecated
    @Internal
    public FieldConfigSchemeClauseContextUtil(IssueTypeSchemeManager issueTypeSchemeManager, ConstantsManager constantsManager, PermissionManager permissionManager, ProjectFactory projectFactory) {
        this(issueTypeSchemeManager, permissionManager);
        String message = "FieldConfigSchemeClauseContextUtil's constructor was inappropriately called directly.";
        log.warn("FieldConfigSchemeClauseContextUtil's constructor was inappropriately called directly.", (Throwable)new IllegalAccessException("FieldConfigSchemeClauseContextUtil's constructor was inappropriately called directly."));
    }

    @Internal
    public FieldConfigSchemeClauseContextUtil(IssueTypeSchemeManager issueTypeSchemeManager, PermissionManager permissionManager) {
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.permissionManager = permissionManager;
    }

    public boolean isConfigSchemeVisibleUnderContext(QueryContext queryContext, FieldConfigScheme fieldConfigScheme) {
        if (fieldConfigScheme.isGlobal()) {
            return true;
        }
        if (fieldConfigScheme.isAllIssueTypes()) {
            return this.fieldConfigSchemeContainsContextProjects(queryContext, fieldConfigScheme);
        }
        if (fieldConfigScheme.isAllProjects()) {
            return this.fieldConfigSchemeContainsContextIssueTypes(queryContext, fieldConfigScheme);
        }
        return this.fieldConfigSchemeContainsContextMapping(queryContext, fieldConfigScheme);
    }

    public FieldConfigScheme getFieldConfigSchemeFromContext(QueryContext queryContext, CustomField customField) {
        FieldConfigScheme mostSpecific = null;
        List<FieldConfigScheme> fieldConfigSchemes = customField.getConfigurationSchemes();
        for (FieldConfigScheme fieldConfigScheme : fieldConfigSchemes) {
            if (!this.isConfigSchemeVisibleUnderContext(queryContext, fieldConfigScheme) || mostSpecific != null && !FieldConfigSchemeClauseContextUtil.moreSpecific(mostSpecific, fieldConfigScheme)) continue;
            mostSpecific = fieldConfigScheme;
        }
        return mostSpecific;
    }

    public ClauseContext getContextForConfigScheme(ApplicationUser searcher, FieldConfigScheme fieldConfigScheme) {
        if (fieldConfigScheme.isAllProjects()) {
            if (fieldConfigScheme.isAllIssueTypes()) {
                return ClauseContextImpl.createGlobalClauseContext();
            }
            return new ClauseContextImpl(FieldConfigSchemeClauseContextUtil.getProjectIssueTypeContextsForIssueTypesOnly(fieldConfigScheme));
        }
        Collection<Project> visibleProjects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, searcher);
        List<Project> fieldConfigSchemeProjects = fieldConfigScheme.getAssociatedProjectObjects();
        Collection projects = CollectionUtils.intersection(visibleProjects, fieldConfigSchemeProjects);
        Set<ProjectIssueTypeContext> projectIssueTypeContextSet = this.issueTypeContextsForProjects(fieldConfigScheme, projects);
        return new ClauseContextImpl(projectIssueTypeContextSet);
    }

    public boolean canSearcherSeeAnyContextsForCustomField(ApplicationUser searcher, CustomField field) {
        Set<Long> visibleProjectIds = WithId.distinctIds(this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, searcher));
        return field.getConfigurationSchemes().stream().anyMatch(scheme -> {
            if (scheme.isAllProjects()) return true;
            if (!scheme.getAssociatedProjectIds().stream().anyMatch(visibleProjectIds::contains)) return false;
            return true;
        });
    }

    boolean fieldConfigSchemeContainsContextProjects(QueryContext queryContext, FieldConfigScheme fieldConfigScheme) {
        Set<Long> projectIdsInScheme = this.getProjectIdsForScheme(fieldConfigScheme);
        return queryContext.getProjectIssueTypeContexts().stream().map(QueryContext.ProjectIssueTypeContexts::getProjectContext).map(ProjectContext::getProjectId).filter(Objects::nonNull).anyMatch(projectIdsInScheme::contains);
    }

    boolean fieldConfigSchemeContainsContextIssueTypes(QueryContext queryContext, FieldConfigScheme fieldConfigScheme) {
        Set<String> issueTypeIdsInScheme = this.getIssueTypeIdsForScheme(fieldConfigScheme);
        return queryContext.getProjectIssueTypeContexts().stream().flatMap(ctx -> ctx.getIssueTypeIds().stream()).filter(Objects::nonNull).anyMatch(issueTypeIdsInScheme::contains);
    }

    boolean fieldConfigSchemeContainsContextMapping(QueryContext queryContext, FieldConfigScheme fieldConfigScheme) {
        return queryContext.getProjectIssueTypeContexts().stream().anyMatch(this.hasProjectInScheme(fieldConfigScheme).and(this.hasIssueTypeInScheme(fieldConfigScheme)));
    }

    private Predicate<QueryContext.ProjectIssueTypeContexts> hasProjectInScheme(FieldConfigScheme fieldConfigScheme) {
        Set<Long> projectIdsForScheme = this.getProjectIdsForScheme(fieldConfigScheme);
        return ctx -> {
            ProjectContext project = ctx.getProjectContext();
            return !project.isAll() && projectIdsForScheme.contains(project.getProjectId());
        };
    }

    private Predicate<QueryContext.ProjectIssueTypeContexts> hasIssueTypeInScheme(FieldConfigScheme fieldConfigScheme) {
        Set<String> issueTypeIdsForScheme = this.getIssueTypeIdsForScheme(fieldConfigScheme);
        return ctx -> ctx.getIssueTypeIds().stream().anyMatch(issueTypeIdsForScheme::contains);
    }

    Set<Long> getProjectIdsForScheme(FieldConfigScheme fieldConfigScheme) {
        return WithId.distinctIds(fieldConfigScheme.getAssociatedProjectObjects());
    }

    Set<String> getIssueTypeIdsForScheme(FieldConfigScheme fieldConfigScheme) {
        Collection<IssueType> issueTypes = fieldConfigScheme.getAssociatedIssueTypes();
        HashSet issueTypeIdsInScheme = Sets.newHashSetWithExpectedSize((int)issueTypes.size());
        issueTypes.forEach(issueType -> issueTypeIdsInScheme.add(issueType.getId()));
        return issueTypeIdsInScheme;
    }

    Set<ProjectIssueTypeContext> issueTypeContextsForProjects(FieldConfigScheme fieldConfigScheme, Collection<Project> projects) {
        if (fieldConfigScheme.isAllIssueTypes()) {
            return FieldConfigSchemeClauseContextUtil.toContextsWithAllIssueTypes(projects);
        }
        Map<String, IssueTypeContext> issueTypeContexts = FieldConfigSchemeClauseContextUtil.associatedIssueTypeMap(fieldConfigScheme);
        Map<Long, List<IssueType>> projectToIssueType = this.issueTypeSchemeManager.getIssueTypesForProjects(projects);
        return projectToIssueType.entrySet().stream().flatMap(entry -> FieldConfigSchemeClauseContextUtil.contextStream((Long)entry.getKey(), (Collection)entry.getValue(), issueTypeContexts)).collect(Collectors.toCollection(HashSet::new));
    }

    private static Stream<? extends ProjectIssueTypeContext> contextStream(Long projectId, Collection<IssueType> issueTypes, Map<String, IssueTypeContext> issueTypeContexts) {
        ProjectContextImpl projectContext = new ProjectContextImpl(projectId);
        return issueTypes.stream().map(issueType -> (IssueTypeContext)issueTypeContexts.get(issueType.getId())).filter(Objects::nonNull).map(issueTypeContext -> FieldConfigSchemeClauseContextUtil.projectIssueTypeContext(projectContext, issueTypeContext));
    }

    private static Map<String, IssueTypeContext> associatedIssueTypeMap(FieldConfigScheme fieldConfigScheme) {
        Collection<String> issueTypeIds = fieldConfigScheme.getAssociatedIssueTypeIds();
        HashMap map = Maps.newHashMapWithExpectedSize((int)issueTypeIds.size());
        issueTypeIds.forEach(id -> {
            IssueTypeContext cfr_ignored_0 = map.put(id, new IssueTypeContextImpl((String)id));
        });
        return map;
    }

    private static Set<ProjectIssueTypeContext> toContextsWithAllIssueTypes(Collection<Project> projects) {
        return projects.stream().map(project -> FieldConfigSchemeClauseContextUtil.projectIssueTypeContext(new ProjectContextImpl(project.getId()), AllIssueTypesContext.INSTANCE)).collect(Collectors.toCollection(HashSet::new));
    }

    private static ProjectIssueTypeContext projectIssueTypeContext(ProjectContext projectContext, IssueTypeContext issueTypeContext) {
        return new ProjectIssueTypeContextImpl(projectContext, issueTypeContext);
    }

    static Set<ProjectIssueTypeContext> getProjectIssueTypeContextsForIssueTypesOnly(FieldConfigScheme fieldConfigScheme) {
        return fieldConfigScheme.getAssociatedIssueTypeIds().stream().map(issueTypeId -> new ProjectIssueTypeContextImpl(AllProjectsContext.INSTANCE, new IssueTypeContextImpl((String)issueTypeId))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static boolean moreSpecific(FieldConfigScheme scheme1, FieldConfigScheme scheme2) {
        if (scheme1.isGlobal()) {
            return true;
        }
        if (scheme1.isAllProjects()) {
            return !scheme2.isAllIssueTypes() || !scheme2.isAllProjects();
        }
        if (scheme1.isAllIssueTypes()) {
            return !scheme2.isAllProjects();
        }
        return !scheme2.isAllIssueTypes() && !scheme2.isAllProjects();
    }
}

