/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.issuefieldoption;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class IssueFieldOptionScopeRequest {
    public static final IssueFieldOptionScopeRequest USER = new IssueFieldOptionScopeRequest(Collections.emptyList());
    @Nonnull
    private final Collection<Long> projectIds;

    public static IssueFieldOptionScopeRequest projects(@Nonnull Collection<Long> projectIds) {
        return new IssueFieldOptionScopeRequest((Collection)Preconditions.checkNotNull(projectIds));
    }

    public static IssueFieldOptionScopeRequest project(@Nullable Long projectId) {
        return new IssueFieldOptionScopeRequest(Optional.ofNullable(projectId).map(Collections::singletonList).orElse(Collections.emptyList()));
    }

    private IssueFieldOptionScopeRequest(@Nonnull Collection<Long> projectIds) {
        this.projectIds = ImmutableList.copyOf(projectIds);
    }

    public Collection<Long> getProjectIds() {
        return this.projectIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueFieldOptionScopeRequest that = (IssueFieldOptionScopeRequest)o;
        return Objects.equals(this.getProjectIds(), that.getProjectIds());
    }

    public int hashCode() {
        return Objects.hash(this.getProjectIds());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("projectIds", this.getProjectIds()).toString();
    }
}

