/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.issuefieldoption;

import com.atlassian.jira.issue.fields.issuefieldoption.IssueFieldOptionScope;
import com.atlassian.jira.issue.fields.issuefieldoption.IssueFieldOptionWithScope;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;

final class IssueFieldOptionImpl
implements IssueFieldOptionWithScope {
    private final Long id;
    private final String value;
    private final ObjectNode properties;
    private final IssueFieldOptionScope scope;

    IssueFieldOptionImpl(Long id, String value, ObjectNode properties, IssueFieldOptionScope scope) {
        this.id = (Long)Preconditions.checkNotNull((Object)id);
        this.value = (String)Preconditions.checkNotNull((Object)value);
        this.properties = Optional.ofNullable(properties).orElse(JsonNodeFactory.instance.objectNode());
        this.scope = (IssueFieldOptionScope)Preconditions.checkNotNull((Object)scope);
    }

    @Override
    public IssueFieldOptionWithScope withScope(IssueFieldOptionScope scope) {
        return new IssueFieldOptionImpl(this.id, this.value, this.properties, scope);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    @Nullable
    public ObjectNode getProperties() {
        return this.properties;
    }

    @Override
    public IssueFieldOptionScope getScope() {
        return this.scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueFieldOptionImpl that = (IssueFieldOptionImpl)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getValue(), that.getValue()) && Objects.equals(this.getProperties(), that.getProperties()) && Objects.equals(this.getScope(), that.getScope());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getValue(), this.getProperties(), this.getScope());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("value", (Object)this.getValue()).add("properties", (Object)this.getProperties()).add("scope", (Object)this.getScope()).toString();
    }
}

