/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.annotations.PublicApi;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;

@PublicApi
public interface IssueTypeService {
    @Deprecated
    public Option<IssueType> getIssueType(ApplicationUser var1, String var2);

    public Optional<IssueType> getIssueType(String var1, ApplicationUser var2);

    public Iterable<IssueType> getIssueTypes(ApplicationUser var1);

    public Iterable<IssueType> getAvailableAlternativesForIssueType(ApplicationUser var1, String var2);

    public CreateValidationResult validateCreateIssueType(ApplicationUser var1, @Nonnull IssueTypeCreateInput var2);

    public IssueTypeResult createIssueType(ApplicationUser var1, @Nonnull CreateValidationResult var2);

    public UpdateValidationResult validateUpdateIssueType(ApplicationUser var1, @Nonnull String var2, @Nonnull IssueTypeUpdateInput var3);

    public IssueTypeResult updateIssueType(ApplicationUser var1, @Nonnull UpdateValidationResult var2);

    public DeleteValidationResult validateDeleteIssueType(ApplicationUser var1, @Nonnull IssueTypeDeleteInput var2);

    public void deleteIssueType(ApplicationUser var1, @Nonnull DeleteValidationResult var2);

    public static class IssueTypeResult {
        private final IssueType issueType;

        public IssueTypeResult(IssueType issueType) {
            this.issueType = issueType;
        }

        public IssueType getIssueType() {
            return this.issueType;
        }
    }

    public static class DeleteValidationResult
    extends ServiceResultImpl {
        private final Option<IssueTypeDeleteInput> issueTypeDeleteInput;

        public DeleteValidationResult(ErrorCollection errorCollection, Option<IssueTypeDeleteInput> issueTypeId) {
            super(errorCollection);
            this.issueTypeDeleteInput = issueTypeId;
        }

        public Option<IssueTypeDeleteInput> getDeleteIssueTypeInput() {
            return this.issueTypeDeleteInput;
        }
    }

    public static class UpdateValidationResult
    extends ServiceResultImpl {
        private final Option<IssueTypeUpdateInput> issueTypeInput;
        private final Option<IssueType> issueType;

        private UpdateValidationResult(ErrorCollection errorCollection, Option<IssueTypeUpdateInput> issueTypeInput, Option<IssueType> issueType) {
            super(errorCollection);
            this.issueTypeInput = issueTypeInput;
            this.issueType = issueType;
        }

        public Option<IssueTypeUpdateInput> getIssueTypeInput() {
            return this.issueTypeInput;
        }

        public Option<IssueType> getIssueType() {
            return this.issueType;
        }

        public static UpdateValidationResult error(ErrorCollection errorCollection) {
            return new UpdateValidationResult(errorCollection, (Option<IssueTypeUpdateInput>)Option.none(IssueTypeUpdateInput.class), (Option<IssueType>)Option.none(IssueType.class));
        }

        public static UpdateValidationResult ok(IssueTypeUpdateInput issueTypeUpdateInput, IssueType issueType) {
            return new UpdateValidationResult(new SimpleErrorCollection(), (Option<IssueTypeUpdateInput>)Option.some((Object)issueTypeUpdateInput), (Option<IssueType>)Option.some((Object)issueType));
        }
    }

    public static class CreateValidationResult
    extends ServiceResultImpl {
        private final Option<IssueTypeCreateInput> issueTypeInput;

        private CreateValidationResult(ErrorCollection errorCollection, Option<IssueTypeCreateInput> issueTypeInput) {
            super(errorCollection);
            this.issueTypeInput = issueTypeInput;
        }

        public Option<IssueTypeCreateInput> getIssueTypeInput() {
            return this.issueTypeInput;
        }

        public static CreateValidationResult ok(IssueTypeCreateInput issueTypeCreateInput) {
            return new CreateValidationResult((ErrorCollection)new SimpleErrorCollection(), (Option<IssueTypeCreateInput>)Option.some((Object)issueTypeCreateInput));
        }

        public static CreateValidationResult error(ErrorCollection errorCollection) {
            return new CreateValidationResult(errorCollection, (Option<IssueTypeCreateInput>)Option.none(IssueTypeCreateInput.class));
        }
    }

    public static class IssueTypeDeleteInput {
        private final String issueTypeToDeleteId;
        private final Option<String> alternativeIssueTypeId;

        public IssueTypeDeleteInput(String issueTypeToDeleteId, Option<String> alternativeIssueTypeId) {
            this.issueTypeToDeleteId = issueTypeToDeleteId;
            this.alternativeIssueTypeId = alternativeIssueTypeId;
        }

        public String getIssueTypeToDeleteId() {
            return this.issueTypeToDeleteId;
        }

        public Option<String> getAlternativeIssueTypeId() {
            return this.alternativeIssueTypeId;
        }
    }

    public static class IssueTypeCreateInput {
        private final String name;
        private final Type type;
        private final Option<String> description;

        private IssueTypeCreateInput(String name, Type type, Option<String> description) {
            this.name = name;
            this.type = type;
            this.description = description;
        }

        public Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Option<String> getDescription() {
            return this.description;
        }

        public static Builder builder() {
            return new Builder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IssueTypeCreateInput that = (IssueTypeCreateInput)o;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return this.type == that.type;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }

        public static class Builder {
            private String description;
            private String name;
            private Type type;

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setType(Type type) {
                this.type = type;
                return this;
            }

            public IssueTypeCreateInput build() {
                Preconditions.checkArgument((this.type != null ? 1 : 0) != 0);
                Preconditions.checkArgument((this.name != null ? 1 : 0) != 0);
                return new IssueTypeCreateInput(this.name, this.type, Option.option((Object)this.description));
            }
        }

        public static enum Type {
            STANDARD,
            SUBTASK;

        }
    }

    public static class IssueTypeUpdateInput {
        private final Long issueTypeToUpdate;
        private final Option<String> name;
        private final Option<String> description;
        private final Option<Long> avatarId;

        protected IssueTypeUpdateInput(Long issueTypeToUpdate, Option<String> name, Option<String> description, Option<Long> avatarId) {
            this.issueTypeToUpdate = issueTypeToUpdate;
            this.name = name;
            this.description = description;
            this.avatarId = avatarId;
        }

        public Option<Long> getAvatarId() {
            return this.avatarId;
        }

        public Long getIssueTypeToUpdate() {
            return this.issueTypeToUpdate;
        }

        public Option<String> getName() {
            return this.name;
        }

        public Option<String> getDescription() {
            return this.description;
        }

        public static Builder builder() {
            return new Builder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IssueTypeUpdateInput that = (IssueTypeUpdateInput)o;
            if (this.avatarId != null ? !this.avatarId.equals(that.avatarId) : that.avatarId != null) {
                return false;
            }
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
                return false;
            }
            if (this.issueTypeToUpdate != null ? !this.issueTypeToUpdate.equals(that.issueTypeToUpdate) : that.issueTypeToUpdate != null) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            int result = this.issueTypeToUpdate != null ? this.issueTypeToUpdate.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.avatarId != null ? this.avatarId.hashCode() : 0);
            return result;
        }

        public static class Builder {
            private String description;
            private String name;
            private Long avatarId;
            private Long issueTypeToUpdateId;

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setAvatarId(Long avatarId) {
                this.avatarId = avatarId;
                return this;
            }

            public void setIssueTypeToUpdateId(Long issueTypeToUpdateId) {
                this.issueTypeToUpdateId = issueTypeToUpdateId;
            }

            public IssueTypeUpdateInput build() {
                return new IssueTypeUpdateInput(this.issueTypeToUpdateId, (Option<String>)Option.option((Object)this.name), (Option<String>)Option.option((Object)this.description), (Option<Long>)Option.option((Object)this.avatarId));
            }
        }
    }
}

