/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.SimpleWarningCollection;
import com.atlassian.jira.util.WarningCollection;
import com.google.common.base.Preconditions;

public final class ServiceOutcomes {
    private ServiceOutcomes() {
    }

    public static <T> ServiceOutcome<T> ok(T value) {
        return new ServiceOutcomeImpl<T>(value, ErrorCollections.empty());
    }

    public static <T> ServiceOutcome<T> error(ErrorCollection errors) {
        return new ServiceOutcomeImpl<Object>(null, errors);
    }

    private static class ServiceOutcomeImpl<T>
    implements ServiceOutcome<T> {
        private final T value;
        private final ErrorCollection errorCollection;

        public ServiceOutcomeImpl(T value, ErrorCollection errorCollection) {
            Preconditions.checkArgument((errorCollection.hasAnyErrors() && value == null || value != null && !errorCollection.hasAnyErrors() ? 1 : 0) != 0, (Object)"value may be null iff. error collection is not empty");
            this.value = value;
            this.errorCollection = errorCollection;
        }

        @Override
        public T getReturnedValue() {
            return this.value;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public boolean isValid() {
            return !this.errorCollection.hasAnyErrors();
        }

        @Override
        public ErrorCollection getErrorCollection() {
            return this.errorCollection;
        }

        @Override
        public WarningCollection getWarningCollection() {
            return new SimpleWarningCollection();
        }
    }
}

