/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.util.handler;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.service.util.handler.MessageUserProcessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.mail.MailUtils;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.mail.Message;
import javax.mail.MessagingException;

@Internal
public class MessageUserProcessorImpl
implements MessageUserProcessor {
    private final UserManager userManager;
    private final UserSearchService userSearchService;

    public MessageUserProcessorImpl(UserManager userManager, UserSearchService userSearchService) {
        this.userManager = userManager;
        this.userSearchService = userSearchService;
    }

    @Override
    @Nullable
    public ApplicationUser getAuthorFromSender(Message message) throws MessagingException {
        String emailAddress;
        List senders = MailUtils.getSenders((Message)message);
        ApplicationUser user = null;
        Iterator iterator = senders.iterator();
        while (iterator.hasNext() && (user = this.findUserByEmail(emailAddress = (String)iterator.next())) == null && (user = this.findUserByUsername(emailAddress)) == null) {
        }
        return user;
    }

    @Override
    @Nullable
    public ApplicationUser findUserByUsername(String username) {
        return this.userManager.getUserByName(username);
    }

    @Override
    @Nullable
    public ApplicationUser findUserByEmail(String emailAddress) {
        Iterator<ApplicationUser> users = this.userSearchService.findUsersByEmail(emailAddress).iterator();
        if (users.hasNext()) {
            return users.next();
        }
        return null;
    }
}

