/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.response;

import com.atlassian.jira.search.aggregation.AggregationsResponse;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.request.PageRequest;
import com.atlassian.jira.search.response.SearchHit;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;

@ExperimentalSearchApi
public class SearchResponse {
    private final List<SearchHit> hits;
    private final PageRequest pageRequest;
    private final long totalHits;
    private final AggregationsResponse aggregations;

    public SearchResponse(long totalHits, List<SearchHit> hits, PageRequest pageRequest) {
        this(totalHits, hits, pageRequest, null);
    }

    public SearchResponse(long totalHits, List<SearchHit> hits, PageRequest pageRequest, @Nullable AggregationsResponse aggregations) {
        this.hits = Objects.requireNonNull(hits);
        this.totalHits = totalHits;
        this.pageRequest = Objects.requireNonNull(pageRequest, "pageRequest");
        this.aggregations = (AggregationsResponse)ObjectUtils.firstNonNull((Object[])new AggregationsResponse[]{aggregations, AggregationsResponse.EMPTY});
    }

    public List<SearchHit> getHits() {
        return this.hits;
    }

    public Optional<PageRequest> getNextPageRequest() {
        int nextPageStart = this.pageRequest.getStart() + this.pageRequest.getLimit();
        if ((long)nextPageStart < this.totalHits) {
            return Optional.of(PageRequest.of(nextPageStart, this.pageRequest.getLimit()));
        }
        return Optional.empty();
    }

    public PageRequest getPageRequest() {
        return this.pageRequest;
    }

    public long getTotalHits() {
        return this.totalHits;
    }

    public AggregationsResponse getAggregations() {
        return this.aggregations;
    }
}

