/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.request;

import com.atlassian.annotations.Internal;
import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@Internal
abstract class AbstractSearchRequestBuilder<T extends AbstractSearchRequestBuilder<T>> {
    protected Set<String> fields = null;
    protected String documentType = null;

    AbstractSearchRequestBuilder() {
    }

    public final T fields(@Nullable Iterable<String> fields) {
        this.fields = fields == null ? null : Streams.stream(fields).filter(Objects::nonNull).collect(Collectors.toSet());
        return this.self();
    }

    public final T fields(String ... fields) {
        this.fields = fields == null ? null : Arrays.stream(fields).filter(Objects::nonNull).collect(Collectors.toSet());
        return this.self();
    }

    public final T documentType(@Nullable String documentType) {
        this.documentType = documentType;
        return this.self();
    }

    protected abstract T self();
}

