/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.VersionResolver;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.jql.AbstractOperatorQueryFactory;
import com.atlassian.jira.search.jql.OperatorSpecificQueryFactory;
import com.atlassian.jira.search.query.DefaultMatchNoDocsQuery;
import com.atlassian.jira.search.query.DefaultTermsSetQuery;
import com.atlassian.jira.util.Predicate;
import com.atlassian.query.operator.Operator;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@ExperimentalSearchApi
public class VersionSpecificRelationalOperatorQueryFactory
extends AbstractOperatorQueryFactory<Version>
implements OperatorSpecificQueryFactory {
    private final VersionResolver versionResolver;
    private final Comparator<? super Version> comparator;
    private final IndexInfoResolver<Version> versionIndexInfoResolver;

    public VersionSpecificRelationalOperatorQueryFactory(Comparator<? super Version> comparator, VersionResolver versionResolver, IndexInfoResolver<Version> versionIndexInfoResolver) {
        super(versionIndexInfoResolver);
        this.versionResolver = versionResolver;
        this.comparator = comparator;
        this.versionIndexInfoResolver = versionIndexInfoResolver;
    }

    @Override
    public Query createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (!this.handlesOperator(operator)) {
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        Stream<Version> versions = this.getIndexValues(rawValues).stream().filter(Objects::nonNull).map(Long::valueOf).map(this.versionResolver::get).distinct();
        Stream<String> matchingVersions = versions.flatMap(version -> {
            List<Version> projectVersions = this.versionResolver.getProjectVersions(version.getProjectId());
            Predicate<Version> versionPredicate = operator.getPredicateForValue(this.comparator, version);
            return projectVersions.stream().filter(versionPredicate::evaluate);
        });
        Set<String> matchingVersionIds = matchingVersions.map(this.versionIndexInfoResolver::getIndexedValue).collect(Collectors.toSet());
        return new DefaultTermsSetQuery(fieldName, matchingVersionIds);
    }

    @Override
    public Query createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    @Override
    public Query createQueryForEmptyOperand(String fieldName, Operator operator) {
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains((Object)operator);
    }
}

