/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.jql.AbstractOperatorQueryFactory;
import com.atlassian.jira.search.jql.OperatorSpecificQueryFactory;
import com.atlassian.jira.search.jql.TermQueryFactory;
import com.atlassian.jira.search.query.BooleanQuery;
import com.atlassian.jira.search.query.DefaultBooleanQuery;
import com.atlassian.jira.search.query.DefaultMatchNoDocsQuery;
import com.atlassian.jira.search.query.DefaultTermsSetQuery;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExperimentalSearchApi
public class VersionLikeQueryFactory
extends AbstractOperatorQueryFactory<Version>
implements OperatorSpecificQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(VersionLikeQueryFactory.class);

    public VersionLikeQueryFactory(IndexInfoResolver<Version> indexInfoResolver) {
        super(indexInfoResolver);
    }

    @Override
    public Query createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (Operator.LIKE.equals((Object)operator)) {
            return this.handleLike(fieldName, this.getIndexValues(rawValues));
        }
        if (Operator.NOT_LIKE.equals((Object)operator)) {
            return this.handleNotLike(fieldName, this.getIndexValues(rawValues));
        }
        log.debug("Create query for single value was called with operator '{}', this only handles '~' and '!~'.", (Object)operator.getDisplayString());
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    private Query handleNotLike(String fieldName, List<String> indexValues) {
        ArrayList notQueries = Lists.newArrayListWithCapacity((int)indexValues.size());
        for (String indexValue : indexValues) {
            notQueries.add(this.getTermQuery(fieldName, indexValue));
        }
        if (notQueries.isEmpty()) {
            return TermQueryFactory.nonEmptyQuery(fieldName);
        }
        DefaultBooleanQuery.Builder boolQuery = new DefaultBooleanQuery.Builder();
        for (Query query : notQueries) {
            boolQuery.add(query, BooleanQuery.Occur.MUST_NOT);
        }
        boolQuery.add(TermQueryFactory.nonEmptyQuery(fieldName), BooleanQuery.Occur.FILTER);
        boolQuery.add(TermQueryFactory.visibilityQuery(fieldName), BooleanQuery.Occur.FILTER);
        return boolQuery.build();
    }

    private Query handleLike(String fieldName, List<String> indexValues) {
        if (indexValues.isEmpty()) {
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        return new DefaultTermsSetQuery(fieldName, indexValues);
    }

    @Override
    public Query createQueryForEmptyOperand(String fieldName, Operator operator) {
        if (operator == Operator.LIKE) {
            return TermQueryFactory.emptyQuery(fieldName);
        }
        if (operator == Operator.NOT_LIKE) {
            return TermQueryFactory.nonEmptyQuery(fieldName);
        }
        log.debug("Create query for empty operand was called with operator '{}', this only handles '~' and '~!' ", (Object)operator.getDisplayString());
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    @Override
    public Query createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        log.debug("LIKE clauses do not support multi value operands.");
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return Operator.LIKE.equals((Object)operator) || Operator.NOT_LIKE.equals((Object)operator);
    }
}

