/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.query.BooleanQuery;
import com.atlassian.jira.search.query.DefaultBooleanQuery;
import com.atlassian.jira.search.query.DefaultTermQuery;
import com.atlassian.jira.search.query.MatchNoDocsQuery;

@ExperimentalSearchApi
public final class TermQueryFactory {
    private TermQueryFactory() {
    }

    public static Query visibilityQuery(String fieldName) {
        return new DefaultTermQuery("visiblefieldids", fieldName);
    }

    public static Query wrapWithVisibilityQuery(String fieldName, Query query) {
        if (query instanceof MatchNoDocsQuery) {
            return query;
        }
        return new DefaultBooleanQuery.Builder().add(query, BooleanQuery.Occur.MUST).add(TermQueryFactory.visibilityQuery(fieldName), BooleanQuery.Occur.FILTER).build();
    }

    public static Query nonEmptyQuery(String fieldName) {
        return new DefaultTermQuery("nonemptyfieldids", fieldName);
    }

    public static Query emptyQuery(String fieldName) {
        BooleanQuery query = DefaultBooleanQuery.mustNot(TermQueryFactory.nonEmptyQuery(fieldName));
        return TermQueryFactory.wrapWithVisibilityQuery(fieldName, query);
    }
}

