/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.jql.AbstractRangeQueryFactory;
import com.atlassian.jira.search.query.DefaultTermRangeQuery;
import com.atlassian.jira.util.Function;

@ExperimentalSearchApi
public class RangeQueryFactory<T>
extends AbstractRangeQueryFactory<T, String> {
    public static RangeQueryFactory<String> stringRangeQueryFactory() {
        return new RangeQueryFactory<String>(String::new);
    }

    public RangeQueryFactory(Function<T, String> valueFactory) {
        super(valueFactory);
    }

    @Override
    Query handleLessThan(String fieldName, T value) {
        return new DefaultTermRangeQuery(fieldName, null, (String)this.valueFactory.apply(value), true, false);
    }

    @Override
    Query handleLessThanEquals(String fieldName, T value) {
        return new DefaultTermRangeQuery(fieldName, null, (String)this.valueFactory.apply(value), true, true);
    }

    @Override
    Query handleGreaterThan(String fieldName, T value) {
        return new DefaultTermRangeQuery(fieldName, (String)this.valueFactory.apply(value), null, false, true);
    }

    @Override
    Query handleGreaterThanEquals(String fieldName, T value) {
        return new DefaultTermRangeQuery(fieldName, (String)this.valueFactory.apply(value), null, true, true);
    }

    @Override
    Query handleDuring(String fieldName, T lowerValue, T upperValue) {
        return new DefaultTermRangeQuery(fieldName, (String)this.valueFactory.apply(lowerValue), (String)this.valueFactory.apply(upperValue), true, true);
    }
}

