/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.lucenelegacy.NumericUtils;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.jql.AbstractNumberOperatorQueryFactory;
import com.atlassian.jira.search.jql.OperatorSpecificQueryFactory;
import com.atlassian.jira.search.jql.TermQueryFactory;
import com.atlassian.jira.search.query.BooleanQuery;
import com.atlassian.jira.search.query.DefaultBooleanQuery;
import com.atlassian.jira.search.query.DefaultMatchNoDocsQuery;
import com.atlassian.jira.search.query.DefaultTermQuery;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExperimentalSearchApi
public class NumberEqualityQueryFactory
extends AbstractNumberOperatorQueryFactory
implements OperatorSpecificQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(NumberEqualityQueryFactory.class);

    public NumberEqualityQueryFactory(DoubleConverter doubleConverter) {
        super(doubleConverter);
    }

    @Override
    public Query createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator != Operator.EQUALS && operator != Operator.NOT_EQUALS) {
            log.debug("Creating an equality query for a single value for field '{}' using unsupported operator: '{}', returning a false result (no issues). Supported operators are: '{}' and '{}'", new Object[]{fieldName, operator, Operator.EQUALS, Operator.NOT_EQUALS});
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        return this.createResult(fieldName, operator, rawValues);
    }

    @Override
    public Query createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator == Operator.IN || operator == Operator.NOT_IN) {
            return this.createResult(fieldName, operator, rawValues);
        }
        log.debug("Creating an equality query for multiple values for field '{}' using unsupported operator: '{}', returning a false result (no issues). Supported operators are: '{}' and '{}'", new Object[]{fieldName, operator, Operator.IN, Operator.NOT_IN});
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    @Override
    public Query createQueryForEmptyOperand(String fieldName, Operator operator) {
        if (operator == Operator.IS || operator == Operator.EQUALS) {
            return this.getIsEmptyQuery(fieldName);
        }
        if (operator == Operator.IS_NOT || operator == Operator.NOT_EQUALS) {
            return this.getIsNotEmptyQuery(fieldName);
        }
        log.debug("Creating an equality query for an empty value for field '{}' using unsupported operator: '{}', returning a false result (no issues). Supported operators are: '{}','{}', '{}' and '{}'", new Object[]{fieldName, operator, Operator.IS, Operator.EQUALS, Operator.IS_NOT, Operator.NOT_EQUALS});
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator);
    }

    private Query createResult(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator == Operator.IN || operator == Operator.EQUALS) {
            return this.handleIn(fieldName, this.getIndexValues(rawValues));
        }
        if (operator == Operator.NOT_IN || operator == Operator.NOT_EQUALS) {
            return this.handleNotIn(fieldName, this.getIndexValues(rawValues));
        }
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    private Query handleIn(String fieldName, List<Double> values) {
        if (values.isEmpty()) {
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        if (values.size() == 1) {
            Double value = values.get(0);
            Query query = value == null ? this.getIsEmptyQuery(fieldName) : this.getTermQuery(fieldName, value);
            return query;
        }
        DefaultBooleanQuery.Builder combined = new DefaultBooleanQuery.Builder();
        for (Double value : values) {
            if (value == null) {
                combined.add(this.getIsEmptyQuery(fieldName), BooleanQuery.Occur.SHOULD);
                continue;
            }
            combined.add(this.getTermQuery(fieldName, value), BooleanQuery.Occur.SHOULD);
        }
        return combined.build();
    }

    private Query handleNotIn(String fieldName, List<Double> values) {
        ArrayList notQueries = Lists.newArrayListWithCapacity((int)values.size());
        for (Double indexValue : values) {
            if (indexValue == null) continue;
            notQueries.add(this.getTermQuery(fieldName, indexValue));
        }
        if (notQueries.isEmpty()) {
            return this.getIsNotEmptyQuery(fieldName);
        }
        DefaultBooleanQuery.Builder boolQuery = new DefaultBooleanQuery.Builder();
        boolQuery.add(this.getIsNotEmptyQuery(fieldName), BooleanQuery.Occur.FILTER);
        for (Query query : notQueries) {
            boolQuery.add(query, BooleanQuery.Occur.MUST_NOT);
        }
        boolQuery.add(TermQueryFactory.visibilityQuery(fieldName), BooleanQuery.Occur.MUST);
        return boolQuery.build();
    }

    private Query getIsEmptyQuery(String fieldName) {
        return TermQueryFactory.emptyQuery(fieldName);
    }

    private Query getIsNotEmptyQuery(String fieldName) {
        return TermQueryFactory.nonEmptyQuery(fieldName);
    }

    private Query getTermQuery(String fieldName, Double value) {
        return new DefaultTermQuery("sort_" + fieldName, NumericUtils.doubleToPrefixCoded((double)value));
    }
}

