/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.util.JqlLocalDateSupport;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.jql.LongPointRangeQueryFactory;
import com.atlassian.jira.search.jql.OperatorSpecificQueryFactory;
import com.atlassian.jira.search.query.DefaultMatchNoDocsQuery;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExperimentalSearchApi
public class LocalDateRelationalQueryFactory
implements OperatorSpecificQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(LocalDateRelationalQueryFactory.class);
    private final LongPointRangeQueryFactory<LocalDate> rangeQueryFactory;
    private final JqlLocalDateSupport jqlLocalDateSupport;

    public LocalDateRelationalQueryFactory(JqlLocalDateSupport jqlLocalDateSupport) {
        this.jqlLocalDateSupport = Objects.requireNonNull(jqlLocalDateSupport);
        this.rangeQueryFactory = new LongPointRangeQueryFactory<LocalDate>(LocalDate::getEpochDays);
    }

    @Override
    public Query createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (!this.handlesSingleValueOperator(operator)) {
            log.debug("LocalDate operands do not support operator '{}'.", (Object)operator.getDisplayString());
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        List<LocalDate> dates = this.jqlLocalDateSupport.getLocalDatesFromQueryLiterals(rawValues);
        if (dates.isEmpty()) {
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        LocalDate value = dates.get(0);
        if (value == null) {
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        return this.rangeQueryFactory.get(operator, fieldName, value);
    }

    @Override
    public Query createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (!this.handlesMultiValueOperator(operator)) {
            log.debug("LocalDate operands do not support operator '{}'.", (Object)operator.getDisplayString());
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        List<LocalDate> dates = this.jqlLocalDateSupport.getLocalDatesFromQueryLiterals(rawValues);
        ImmutableList filteredDates = ImmutableList.copyOf((Iterable)Iterables.filter(dates, Objects::nonNull));
        if (filteredDates.isEmpty()) {
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        return this.rangeQueryFactory.handleDuring(fieldName, (LocalDate)filteredDates.get(0), (LocalDate)filteredDates.get(1));
    }

    @Override
    public Query createQueryForEmptyOperand(String fieldName, Operator operator) {
        log.debug("Empty operands are not supported by this query factory.");
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    private boolean handlesSingleValueOperator(Operator operator) {
        return OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains((Object)operator);
    }

    private boolean handlesMultiValueOperator(Operator operator) {
        return operator == Operator.DURING;
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return this.handlesSingleValueOperator(operator) || this.handlesMultiValueOperator(operator);
    }
}

