/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.util.JqlLocalDateSupport;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.jql.ClauseQueryMapper;
import com.atlassian.jira.search.jql.GenericClauseQueryMapper;
import com.atlassian.jira.search.jql.LocalDateEqualityQueryFactory;
import com.atlassian.jira.search.jql.LocalDateRelationalQueryFactory;
import com.atlassian.jira.search.jql.OperatorSpecificQueryFactory;
import com.atlassian.query.clause.TerminalClause;
import java.util.List;
import java.util.Objects;

@ExperimentalSearchApi
public class LocalDateClauseQueryMapper
implements ClauseQueryMapper {
    private final ClauseQueryMapper delegate;

    public LocalDateClauseQueryMapper(String documentFieldName, JqlLocalDateSupport jqlLocalDateSupport, JqlOperandResolver operandResolver) {
        Objects.requireNonNull(documentFieldName);
        Objects.requireNonNull(jqlLocalDateSupport);
        Objects.requireNonNull(operandResolver);
        List<OperatorSpecificQueryFactory> operatorFactories = List.of(new LocalDateEqualityQueryFactory(jqlLocalDateSupport), new LocalDateRelationalQueryFactory(jqlLocalDateSupport));
        this.delegate = new GenericClauseQueryMapper(documentFieldName, operatorFactories, operandResolver);
    }

    @Override
    public Query map(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        return this.delegate.map(queryCreationContext, terminalClause);
    }
}

