/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.util.JqlIssueKeySupport;
import com.atlassian.jira.jql.util.JqlIssueSupport;
import com.atlassian.jira.lucenelegacy.NumberTools;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.jql.ClauseQueryMapper;
import com.atlassian.jira.search.query.BooleanQuery;
import com.atlassian.jira.search.query.DefaultBooleanQuery;
import com.atlassian.jira.search.query.DefaultMatchNoDocsQuery;
import com.atlassian.jira.search.query.DefaultTermQuery;
import com.atlassian.jira.search.query.DefaultTermRangeQuery;
import com.atlassian.jira.search.query.DefaultTermsSetQuery;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InjectableComponent
@ExperimentalSearchApi
public class IssueIdClauseQueryMapper
implements ClauseQueryMapper {
    private static final Logger log = LoggerFactory.getLogger(IssueIdClauseQueryMapper.class);
    private final JqlOperandResolver operandResolver;
    private final JqlIssueKeySupport issueKeySupport;
    private final JqlIssueSupport issueSupport;

    public IssueIdClauseQueryMapper(JqlOperandResolver operandResolver, JqlIssueKeySupport issueKeySupport, JqlIssueSupport issueSupport) {
        this.issueSupport = Objects.requireNonNull(issueSupport);
        this.issueKeySupport = Objects.requireNonNull(issueKeySupport);
        this.operandResolver = Objects.requireNonNull(operandResolver);
    }

    private boolean isNegationOperator(Operator operator) {
        return operator == Operator.NOT_EQUALS || operator == Operator.NOT_IN || operator == Operator.IS_NOT;
    }

    private boolean isEqualityOperator(Operator operator) {
        return operator == Operator.EQUALS || operator == Operator.IN || operator == Operator.IS;
    }

    private boolean isRelationalOperator(Operator operator) {
        return OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains((Object)operator);
    }

    @Override
    public Query map(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        Objects.requireNonNull(queryCreationContext);
        Operand operand = terminalClause.getOperand();
        Operator operator = terminalClause.getOperator();
        if (OperatorClasses.EMPTY_ONLY_OPERATORS.contains((Object)operator) && !operand.equals(EmptyOperand.EMPTY)) {
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        List<QueryLiteral> literals = this.operandResolver.getValues(queryCreationContext, operand, terminalClause);
        if (literals == null) {
            log.debug("Unable to find operand values from operand '{}' for clause '{}'.", (Object)operand.getDisplayString(), (Object)terminalClause.getName());
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        if (this.isEqualityOperator(operator)) {
            return this.createPositiveEqualsQuery(literals);
        }
        if (this.isNegationOperator(operator)) {
            return DefaultBooleanQuery.mustNot(this.createPositiveEqualsQuery(literals));
        }
        if (this.isRelationalOperator(operator)) {
            if (this.operandResolver.isListOperand(operand)) {
                log.debug("Tried to use list operand '{}' with relational operator '{}' in clause '{}'.", new Object[]{operand.getDisplayString(), operator.getDisplayString(), terminalClause.getName()});
                return DefaultMatchNoDocsQuery.INSTANCE;
            }
            QueryLiteral literal = this.operandResolver.getSingleValue(queryCreationContext.getApplicationUser(), operand, terminalClause);
            return this.handleRelational(queryCreationContext.getApplicationUser(), queryCreationContext.isSecurityOverriden(), operator, literal, terminalClause);
        }
        log.debug("The '{}' clause does not support the {} operator.", (Object)terminalClause.getName(), (Object)operator);
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    private Query handleRelational(ApplicationUser user, boolean overrideSecurity, Operator operator, QueryLiteral literal, TerminalClause clause) {
        return this.handleRelational(user, overrideSecurity, literal, clause, IssueIdClauseQueryMapper.createRangeQueryGenerator(operator));
    }

    private Query handleRelational(ApplicationUser user, boolean overrideSecurity, QueryLiteral literal, TerminalClause clause, RangeQueryGenerator rangeQueryGenerator) {
        if (literal.isEmpty()) {
            log.debug("Encountered EMPTY literal from operand '{}' for operator '{}' on clause '{}'. Ignoring.", new Object[]{clause.getOperand().getDisplayString(), clause.getOperator().getDisplayString(), clause.getName()});
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        return this.getIssue(user, overrideSecurity, literal).map(issue -> {
            long currentCount = this.issueKeySupport.parseKeyNum(issue.getKey());
            if (currentCount < 0L) {
                return DefaultMatchNoDocsQuery.INSTANCE;
            }
            return new DefaultBooleanQuery.Builder().add(rangeQueryGenerator.get(currentCount), BooleanQuery.Occur.MUST).add(IssueIdClauseQueryMapper.createProjectQuery(issue.getProjectId()), BooleanQuery.Occur.FILTER).build();
        }).orElse(DefaultMatchNoDocsQuery.INSTANCE);
    }

    private Optional<Issue> getIssue(ApplicationUser user, boolean overrideSecurity, QueryLiteral literal) {
        if (literal.getLongValue() != null) {
            return Optional.ofNullable(overrideSecurity ? this.issueSupport.getIssue(literal.getLongValue()) : this.issueSupport.getIssue(literal.getLongValue(), user));
        }
        if (literal.getStringValue() != null) {
            return Optional.ofNullable(overrideSecurity ? this.issueSupport.getIssue(literal.getStringValue()) : this.issueSupport.getIssue(literal.getStringValue(), user));
        }
        return Optional.empty();
    }

    private Query createPositiveEqualsQuery(List<QueryLiteral> literals) {
        if (literals.size() == 1) {
            return this.createSingleValueQuery(literals.get(0));
        }
        return this.createMultiValuePositiveEqualsQuery(literals);
    }

    private Query createMultiValuePositiveEqualsQuery(List<QueryLiteral> literals) {
        List<String> terms = literals.stream().flatMap(literal -> this.extractIssueId((QueryLiteral)literal).stream()).map(Object::toString).toList();
        return new DefaultTermsSetQuery(Objects.requireNonNull(SystemSearchConstants.forIssueId().getIndexField()), terms);
    }

    private Query createSingleValueQuery(QueryLiteral literal) {
        return this.extractIssueId(literal).map(this::createQueryForId).orElse(DefaultMatchNoDocsQuery.INSTANCE);
    }

    private Optional<Long> extractIssueId(QueryLiteral literal) {
        if (literal.isEmpty()) {
            return Optional.empty();
        }
        if (literal.getStringValue() != null) {
            return Optional.ofNullable(this.issueSupport.getIssue(literal.getStringValue())).map(Issue::getId);
        }
        return Optional.ofNullable(literal.getLongValue());
    }

    private Query createQueryForId(Long id) {
        return new DefaultTermQuery(Objects.requireNonNull(SystemSearchConstants.forIssueId().getIndexField()), id.toString());
    }

    private static Query createProjectQuery(Long projectId) {
        return new DefaultTermQuery(Objects.requireNonNull(SystemSearchConstants.forProject().getIndexField()), projectId.toString());
    }

    private static Query createRangeQuery(long min, long max, boolean minInclusive, boolean maxInclusive) {
        return new DefaultTermRangeQuery(Objects.requireNonNull(SystemSearchConstants.forIssueKey().getKeyIndexOrderField()), IssueIdClauseQueryMapper.processRangeLong(min), IssueIdClauseQueryMapper.processRangeLong(max), minInclusive, maxInclusive);
    }

    @Nullable
    private static String processRangeLong(long value) {
        if (value < 0L) {
            return null;
        }
        return NumberTools.longToString((long)value);
    }

    private static RangeQueryGenerator createRangeQueryGenerator(Operator operator) {
        return switch (operator) {
            case Operator.LESS_THAN -> limit -> IssueIdClauseQueryMapper.createRangeQuery(-1L, limit, true, false);
            case Operator.LESS_THAN_EQUALS -> limit -> IssueIdClauseQueryMapper.createRangeQuery(-1L, limit, true, true);
            case Operator.GREATER_THAN -> limit -> IssueIdClauseQueryMapper.createRangeQuery(limit, -1L, false, true);
            case Operator.GREATER_THAN_EQUALS -> limit -> IssueIdClauseQueryMapper.createRangeQuery(limit, -1L, true, true);
            default -> throw new IllegalArgumentException("Unsupported Operator:" + String.valueOf((Object)operator));
        };
    }

    private static interface RangeQueryGenerator {
        public Query get(long var1);
    }
}

