/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.util.IndexValueConverter;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.jql.AbstractActualValueOperatorQueryFactory;
import com.atlassian.jira.search.jql.OperatorSpecificQueryFactory;
import com.atlassian.jira.search.jql.TermQueryFactory;
import com.atlassian.jira.search.query.BooleanQuery;
import com.atlassian.jira.search.query.DefaultBooleanQuery;
import com.atlassian.jira.search.query.DefaultMatchNoDocsQuery;
import com.atlassian.jira.search.query.DefaultTermQuery;
import com.atlassian.jira.search.query.TermQuery;
import com.atlassian.query.operator.Operator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExperimentalSearchApi
public class ActualValueEqualityQueryFactory
extends AbstractActualValueOperatorQueryFactory
implements OperatorSpecificQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(ActualValueEqualityQueryFactory.class);
    private final String emptyIndexValue;

    public ActualValueEqualityQueryFactory(IndexValueConverter indexValueConverter, String emptyIndexValue) {
        super(indexValueConverter);
        this.emptyIndexValue = Objects.requireNonNull(emptyIndexValue);
    }

    public ActualValueEqualityQueryFactory(IndexValueConverter indexValueConverter) {
        super(indexValueConverter);
        this.emptyIndexValue = null;
    }

    @Override
    public Query createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator != Operator.EQUALS && operator != Operator.NOT_EQUALS) {
            log.debug("Creating an equality query for a single value for field '{}' using unsupported operator: '{}', returning a false result (no issues). Supported operators are: '{}' and '{}'", new Object[]{fieldName, operator, Operator.EQUALS, Operator.NOT_EQUALS});
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        return this.createResult(fieldName, operator, rawValues);
    }

    @Override
    public Query createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator == Operator.IN || operator == Operator.NOT_IN) {
            return this.createResult(fieldName, operator, rawValues);
        }
        log.debug("Creating an equality query for multiple values for field '{}' using unsupported operator: '{}', returning a false result (no issues). Supported operators are: '{}' and '{}'", new Object[]{fieldName, operator, Operator.IN, Operator.NOT_IN});
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    @Override
    public Query createQueryForEmptyOperand(String fieldName, Operator operator) {
        if (operator == Operator.IS || operator == Operator.EQUALS) {
            return this.getIsEmptyQuery(fieldName);
        }
        if (operator == Operator.IS_NOT || operator == Operator.NOT_EQUALS) {
            return this.getIsNotEmptyQuery(fieldName);
        }
        log.debug("Creating an equality query for an empty value for field '{}' using unsupported operator: '{}', returning a false result (no issues). Supported operators are: '{}','{}', '{}' and '{}'", new Object[]{fieldName, operator, Operator.IS, Operator.EQUALS, Operator.IS_NOT, Operator.NOT_EQUALS});
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator);
    }

    private Query createResult(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator == Operator.IN || operator == Operator.EQUALS) {
            return this.handleIn(fieldName, this.getIndexValues(rawValues));
        }
        return this.handleNotIn(fieldName, this.getIndexValues(rawValues));
    }

    private Query handleIn(String fieldName, List<String> values) {
        if (values.size() == 1) {
            String value = values.get(0);
            return value == null ? this.getIsEmptyQuery(fieldName) : this.getTermQuery(fieldName, value);
        }
        DefaultBooleanQuery.Builder combined = new DefaultBooleanQuery.Builder();
        for (String value : values) {
            if (value == null) {
                combined.add(this.getIsEmptyQuery(fieldName), BooleanQuery.Occur.SHOULD);
                continue;
            }
            combined.add(this.getTermQuery(fieldName, value), BooleanQuery.Occur.SHOULD);
        }
        return combined.build();
    }

    private Query handleNotIn(String fieldName, List<String> values) {
        List<TermQuery> notQueries = values.stream().filter(Objects::nonNull).map(value -> this.getTermQuery(fieldName, (String)value)).toList();
        if (notQueries.isEmpty()) {
            return this.getIsNotEmptyQuery(fieldName);
        }
        DefaultBooleanQuery.Builder boolQuery = new DefaultBooleanQuery.Builder();
        boolQuery.add(this.getIsNotEmptyQuery(fieldName), BooleanQuery.Occur.FILTER);
        for (Query query : notQueries) {
            boolQuery.add(query, BooleanQuery.Occur.MUST_NOT);
        }
        boolQuery.add(TermQueryFactory.visibilityQuery(fieldName), BooleanQuery.Occur.FILTER);
        return boolQuery.build();
    }

    private Query getIsEmptyQuery(String fieldName) {
        if (this.emptyIndexValue != null) {
            return this.getTermQuery(fieldName, this.emptyIndexValue);
        }
        return TermQueryFactory.emptyQuery(fieldName);
    }

    private Query getIsNotEmptyQuery(String fieldName) {
        if (this.emptyIndexValue != null) {
            BooleanQuery query = DefaultBooleanQuery.mustNot(this.getTermQuery(fieldName, this.emptyIndexValue));
            return TermQueryFactory.wrapWithVisibilityQuery(fieldName, query);
        }
        return TermQueryFactory.nonEmptyQuery(fieldName);
    }

    private TermQuery getTermQuery(String fieldName, String value) {
        return new DefaultTermQuery(fieldName, value);
    }
}

