/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.vdi.CustomFieldPrefetchedData;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.FieldIndexerUtil;
import com.atlassian.jira.issue.index.indexers.phrase.PhraseQuerySupportField;
import com.atlassian.jira.search.Field;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.field.AbstractField;
import com.atlassian.jira.search.field.AnalyzedTextField;
import com.atlassian.jira.search.field.FieldValueCollector;
import com.atlassian.jira.search.field.KeywordField;
import com.atlassian.jira.search.issue.index.indexers.impl.BaseCustomFieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collection;
import java.util.stream.Stream;

@ExperimentalSearchApi
public class SortableTextCustomFieldIndexer
extends BaseCustomFieldIndexer {
    private final boolean skipsIndexingNull;
    private final KeywordField sortField;

    private static AnalyzedTextField buildVisibleField(CustomField customField) {
        return (AnalyzedTextField)((AbstractField.Builder)((AbstractField.Builder)AnalyzedTextField.builder(customField.getId()).stored()).indexed()).subfield((Field)((AbstractField.Builder)((AbstractField.Builder)AnalyzedTextField.builder("pq_support").stored()).indexed()).overrideLuceneName(PhraseQuerySupportField.forIndexField(customField.getId())).build()).build();
    }

    private static KeywordField buildUnsearchableField(CustomField customField) {
        return (KeywordField)((AbstractField.Builder)KeywordField.builder(customField.getId() + "_unsearchable").stored()).overrideLuceneName(customField.getId()).subfield((Field)((AbstractField.Builder)KeywordField.builder("pq_support").stored()).overrideLuceneName(PhraseQuerySupportField.forIndexField(customField.getId())).build()).build();
    }

    private static KeywordField buildSortField(CustomField customField) {
        return (KeywordField)KeywordField.builder("sort_" + customField.getId()).docValues().build();
    }

    public SortableTextCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, boolean skipsIndexingNull) {
        super(fieldVisibilityManager, customField, SortableTextCustomFieldIndexer.buildVisibleField(customField), SortableTextCustomFieldIndexer.buildUnsearchableField(customField));
        this.skipsIndexingNull = skipsIndexingNull;
        this.sortField = SortableTextCustomFieldIndexer.buildSortField(customField);
    }

    @Override
    public Collection<Field> getFields() {
        return Stream.concat(super.getFields().stream(), Stream.of(this.sortField)).toList();
    }

    @Override
    public void indexFields(FieldValueCollector collector, Issue issue, CustomFieldPrefetchedData prefetchedData) {
        String value = (String)this.customField.getValue(issue);
        String valueForSorting = FieldIndexerUtil.getValueForSorting(value);
        boolean visibleAndInScope = this.isFieldVisibleAndInScope(issue);
        if (value != null) {
            if (visibleAndInScope) {
                collector.add(this.visibleField.name(), value);
                collector.add(this.sortField.name(), valueForSorting);
            } else {
                collector.add(this.invisibleField.name(), value);
            }
        } else if (visibleAndInScope && !this.skipsIndexingNull) {
            collector.add(this.sortField.name(), valueForSorting);
        }
    }
}

